/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.stresstests;

import java.io.File;
import java.io.PrintStream;
import org.neo4j.causalclustering.catchup.storecopy.CopiedStoreRecovery;
import org.neo4j.causalclustering.catchup.storecopy.TemporaryStoreDirectory;
import org.neo4j.causalclustering.discovery.ClusterMember;
import org.neo4j.causalclustering.stresstests.Control;
import org.neo4j.causalclustering.stresstests.RepeatOnRandomCore;
import org.neo4j.causalclustering.stresstests.Resources;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.consistency.ConsistencyCheckTool;
import org.neo4j.io.NullOutputStream;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.impl.muninn.StandalonePageCacheFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.KernelExtensions;
import org.neo4j.logging.Log;

class StartStopRandomCore
extends RepeatOnRandomCore {
    private final FileSystemAbstraction fs;
    private final PageCache pageCache;
    private final Log log;

    StartStopRandomCore(Control control, Resources resources) {
        super(control, resources);
        this.fs = resources.fileSystem();
        this.pageCache = resources.pageCache();
        this.log = resources.logProvider().getLog(this.getClass());
    }

    @Override
    protected void doWorkOnMember(ClusterMember member) throws InterruptedException {
        File storeDir = member.database().getStoreDir();
        KernelExtensions kernelExtensions = (KernelExtensions)member.database().getDependencyResolver().resolveDependency(KernelExtensions.class);
        this.log.info("Stopping: " + member);
        member.shutdown();
        this.assertStoreConsistent(storeDir, kernelExtensions);
        Thread.sleep(5000L);
        this.log.info("Starting: " + member);
        member.start();
    }

    private void assertStoreConsistent(File storeDir, KernelExtensions kernelExtensions) {
        File parent = storeDir.getParentFile();
        try (TemporaryStoreDirectory storeDirectory = new TemporaryStoreDirectory(this.fs, this.pageCache, parent);
             PageCache pageCache = StandalonePageCacheFactory.createPageCache((FileSystemAbstraction)this.fs);){
            this.fs.copyRecursively(storeDir, storeDirectory.storeDir());
            new CopiedStoreRecovery(Config.defaults(), kernelExtensions.listFactories(), pageCache).recoverCopiedStore(storeDirectory.storeDir());
            ConsistencyCheckService.Result result = ConsistencyCheckTool.runConsistencyCheckTool((String[])new String[]{storeDir.getAbsolutePath()}, (PrintStream)new PrintStream(NullOutputStream.NULL_OUTPUT_STREAM), (PrintStream)new PrintStream(NullOutputStream.NULL_OUTPUT_STREAM));
            if (!result.isSuccessful()) {
                throw new RuntimeException("Not consistent database in " + storeDir);
            }
        }
        catch (Throwable e) {
            throw new RuntimeException("Failed to run CC on " + storeDir, e);
        }
    }
}

