/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helper;

import java.util.Map;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.impl.enterprise.configuration.OnlineBackupSettings;

public class DatabaseConfiguration {
    private DatabaseConfiguration() {
    }

    public static Map<String, String> configureTxLogRotationAndPruning(Map<String, String> settings, String txPrune) {
        settings.put(GraphDatabaseSettings.keep_logical_logs.name(), txPrune);
        settings.put(GraphDatabaseSettings.logical_log_rotation_threshold.name(), "1M");
        settings.put(GraphDatabaseSettings.check_point_policy.name(), "continuous");
        return settings;
    }

    public static Map<String, String> configureBackup(Map<String, String> settings, String hostname, int port) {
        settings.put(OnlineBackupSettings.online_backup_enabled.name(), "true");
        settings.put(OnlineBackupSettings.online_backup_server.name(), hostname + ":" + port);
        return settings;
    }
}

