/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helper;

import org.neo4j.causalclustering.stresstests.Control;

public abstract class Workload
implements Runnable {
    private final Control control;
    private final long sleepTimeMillis;

    public Workload(Control control) {
        this(control, 0L);
    }

    public Workload(Control control, long sleepTimeMillis) {
        this.control = control;
        this.sleepTimeMillis = sleepTimeMillis;
    }

    @Override
    public final void run() {
        try {
            while (this.control.keepGoing()) {
                this.doWork();
                if (this.sleepTimeMillis == 0L) continue;
                Thread.sleep(this.sleepTimeMillis);
            }
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
        catch (Throwable t) {
            this.control.onFailure(t);
        }
    }

    protected abstract void doWork() throws Exception;

    public void prepare() throws Exception {
    }

    public void validate() throws Exception {
    }
}

