/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.population;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.apache.commons.lang3.SystemUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.helper.StressTestingHelper;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.test.TestGraphDatabaseFactory;

public class LucenePartitionedIndexStressTesting {
    private static final String LABEL = "label";
    private static final String PROPERTY_PREFIX = "property";
    private static final String UNIQUE_PROPERTY_PREFIX = "uniqueProperty";
    private static final int NUMBER_OF_PROPERTIES = 2;
    private static final int NUMBER_OF_POPULATORS = Integer.valueOf(StressTestingHelper.fromEnv("LUCENE_INDEX_NUMBER_OF_POPULATORS", String.valueOf(Runtime.getRuntime().availableProcessors() - 1)));
    private static final int BATCH_SIZE = Integer.valueOf(StressTestingHelper.fromEnv("LUCENE_INDEX_POPULATION_BATCH_SIZE", String.valueOf(10000)));
    private static final long NUMBER_OF_NODES = Long.valueOf(StressTestingHelper.fromEnv("LUCENE_PARTITIONED_INDEX_NUMBER_OF_NODES", String.valueOf(100000)));
    private static final String WORK_DIRECTORY = StressTestingHelper.fromEnv("LUCENE_PARTITIONED_INDEX_WORKING_DIRECTORY", SystemUtils.JAVA_IO_TMPDIR);
    private static final int WAIT_DURATION_MINUTES = Integer.valueOf(StressTestingHelper.fromEnv("LUCENE_PARTITIONED_INDEX_WAIT_TILL_ONLINE", String.valueOf(30)));
    private ExecutorService populators;
    private GraphDatabaseService db;
    private File storeDir;

    @Before
    public void setUp() throws IOException {
        this.storeDir = this.prepareStoreDir();
        System.out.println(String.format("Starting database at: %s", this.storeDir));
        this.populators = Executors.newFixedThreadPool(NUMBER_OF_POPULATORS);
        this.db = new TestGraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.storeDir).newGraphDatabase();
    }

    @After
    public void tearDown() throws IOException {
        this.db.shutdown();
        this.populators.shutdown();
        FileUtils.deleteRecursively((File)this.storeDir);
    }

    @Test
    public void indexCreationStressTest() throws Exception {
        this.createIndexes();
        this.createUniqueIndexes();
        PopulationResult populationResult = this.populateDatabase();
        this.findLastTrackedNodesByLabelAndProperties(this.db, populationResult);
        this.dropAllIndexes();
        this.createUniqueIndexes();
        this.createIndexes();
        this.findLastTrackedNodesByLabelAndProperties(this.db, populationResult);
    }

    private void dropAllIndexes() {
        try (Transaction transaction = this.db.beginTx();){
            Schema schema = this.db.schema();
            schema.getConstraints().forEach(ConstraintDefinition::drop);
            schema.getIndexes().forEach(IndexDefinition::drop);
            transaction.success();
        }
    }

    private void createIndexes() {
        this.createIndexes(false);
    }

    private void createUniqueIndexes() {
        this.createIndexes(true);
    }

    private void createIndexes(boolean unique) {
        System.out.println(String.format("Creating %d%s indexes.", 2, unique ? " unique" : ""));
        long creationStart = System.nanoTime();
        this.createAndWaitForIndexes(unique);
        System.out.println(String.format("%d%s indexes created.", 2, unique ? " unique" : ""));
        System.out.println("Creation took: " + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - creationStart) + " ms.");
    }

    private PopulationResult populateDatabase() throws ExecutionException, InterruptedException {
        System.out.println("Starting database population.");
        long populationStart = System.nanoTime();
        PopulationResult populationResult = this.populateDb(this.db);
        System.out.println("Database population completed. Inserted " + populationResult.numberOfNodes + " nodes.");
        System.out.println("Population took: " + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - populationStart) + " ms.");
        return populationResult;
    }

    private void findLastTrackedNodesByLabelAndProperties(GraphDatabaseService db, PopulationResult populationResult) {
        try (Transaction ignored = db.beginTx();){
            Node nodeByUniqueStringProperty = db.findNode(Label.label((String)LABEL), LucenePartitionedIndexStressTesting.getUniqueStringProperty(), (Object)(populationResult.maxPropertyId + ""));
            Node nodeByStringProperty = db.findNode(Label.label((String)LABEL), LucenePartitionedIndexStressTesting.getStringProperty(), (Object)(populationResult.maxPropertyId + ""));
            Assert.assertNotNull((String)"Should find last inserted node", (Object)nodeByStringProperty);
            Assert.assertEquals((String)"Both nodes should be the same last inserted node", (Object)nodeByStringProperty, (Object)nodeByUniqueStringProperty);
            Node nodeByUniqueLongProperty = db.findNode(Label.label((String)LABEL), LucenePartitionedIndexStressTesting.getUniqueLongProperty(), (Object)populationResult.maxPropertyId);
            Node nodeByLongProperty = db.findNode(Label.label((String)LABEL), LucenePartitionedIndexStressTesting.getLongProperty(), (Object)populationResult.maxPropertyId);
            Assert.assertNotNull((String)"Should find last inserted node", (Object)nodeByLongProperty);
            Assert.assertEquals((String)"Both nodes should be the same last inserted node", (Object)nodeByLongProperty, (Object)nodeByUniqueLongProperty);
        }
    }

    private File prepareStoreDir() throws IOException {
        Path storeDirPath = Paths.get(WORK_DIRECTORY, new String[0]).resolve(Paths.get("storeDir", new String[0]));
        File storeDirectory = storeDirPath.toFile();
        FileUtils.deleteRecursively((File)storeDirectory);
        storeDirectory.deleteOnExit();
        return storeDirectory;
    }

    private PopulationResult populateDb(GraphDatabaseService db) throws ExecutionException, InterruptedException {
        AtomicLong nodesCounter = new AtomicLong();
        ArrayList<Future<Long>> futures = new ArrayList<Future<Long>>(NUMBER_OF_POPULATORS);
        for (int i = 0; i < NUMBER_OF_POPULATORS; ++i) {
            futures.add(this.populators.submit(new Populator(i, NUMBER_OF_POPULATORS, db, nodesCounter)));
        }
        long maxPropertyId = 0L;
        for (Future future : futures) {
            maxPropertyId = Math.max(maxPropertyId, (Long)future.get());
        }
        return new PopulationResult(maxPropertyId, nodesCounter.get());
    }

    private void createAndWaitForIndexes(boolean unique) {
        try (Transaction transaction = this.db.beginTx();){
            for (int i = 0; i < 2; ++i) {
                if (unique) {
                    this.createUniqueConstraint(i);
                    continue;
                }
                this.createIndex(i);
            }
            transaction.success();
        }
        this.awaitIndexesOnline(this.db);
    }

    private void createUniqueConstraint(int index) {
        this.db.schema().constraintFor(Label.label((String)LABEL)).assertPropertyIsUnique(UNIQUE_PROPERTY_PREFIX + index).create();
    }

    private void createIndex(int index) {
        this.db.schema().indexFor(Label.label((String)LABEL)).on(PROPERTY_PREFIX + index).create();
    }

    private void awaitIndexesOnline(GraphDatabaseService db) {
        try (Transaction ignored = db.beginTx();){
            Schema schema = db.schema();
            schema.awaitIndexesOnline((long)WAIT_DURATION_MINUTES, TimeUnit.MINUTES);
        }
    }

    private static String getLongProperty() {
        return "property1";
    }

    private static String getStringProperty() {
        return "property0";
    }

    private static String getUniqueLongProperty() {
        return "uniqueProperty1";
    }

    private static String getUniqueStringProperty() {
        return "uniqueProperty0";
    }

    private class PopulationResult {
        private long maxPropertyId;
        private long numberOfNodes;

        PopulationResult(long maxPropertyId, long numberOfNodes) {
            this.maxPropertyId = maxPropertyId;
            this.numberOfNodes = numberOfNodes;
        }
    }

    private static class Populator
    implements Callable<Long> {
        private final int populatorNumber;
        private final int step;
        private GraphDatabaseService db;
        private AtomicLong nodesCounter;

        Populator(int populatorNumber, int step, GraphDatabaseService db, AtomicLong nodesCounter) {
            this.populatorNumber = populatorNumber;
            this.step = step;
            this.db = db;
            this.nodesCounter = nodesCounter;
        }

        @Override
        public Long call() {
            SequentialLongSupplier longSupplier = new SequentialLongSupplier(this.populatorNumber, this.step);
            SequentialStringSupplier stringSupplier = new SequentialStringSupplier(this.populatorNumber, this.step);
            while (this.nodesCounter.get() < NUMBER_OF_NODES) {
                long nodesInTotal = this.nodesCounter.addAndGet(this.insertBatchNodes(this.db, stringSupplier, longSupplier));
                if (nodesInTotal % 1000000L != 0L) continue;
                System.out.println("Inserted " + nodesInTotal + " nodes.");
            }
            return longSupplier.value;
        }

        private int insertBatchNodes(GraphDatabaseService db, Supplier<String> stringValueSupplier, LongSupplier longSupplier) {
            try (Transaction transaction = db.beginTx();){
                for (int i = 0; i < BATCH_SIZE; ++i) {
                    Node node = db.createNode(new Label[]{Label.label((String)LucenePartitionedIndexStressTesting.LABEL)});
                    String stringValue = stringValueSupplier.get();
                    long longValue = longSupplier.getAsLong();
                    node.setProperty(LucenePartitionedIndexStressTesting.getStringProperty(), (Object)stringValue);
                    node.setProperty(LucenePartitionedIndexStressTesting.getLongProperty(), (Object)longValue);
                    node.setProperty(LucenePartitionedIndexStressTesting.getUniqueStringProperty(), (Object)stringValue);
                    node.setProperty(LucenePartitionedIndexStressTesting.getUniqueLongProperty(), (Object)longValue);
                }
                transaction.success();
            }
            return BATCH_SIZE;
        }
    }

    private static class SequentialLongSupplier
    implements LongSupplier {
        long value;
        private int step;

        SequentialLongSupplier(int populatorNumber, int step) {
            this.value = populatorNumber;
            this.step = step;
        }

        @Override
        public long getAsLong() {
            this.value += (long)this.step;
            return this.value;
        }
    }

    private static class SequentialStringSupplier
    implements Supplier<String> {
        private final int step;
        long value;

        SequentialStringSupplier(int populatorNumber, int step) {
            this.value = populatorNumber;
            this.step = step;
        }

        @Override
        public String get() {
            this.value += (long)this.step;
            return this.value + "";
        }
    }
}

