/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.stresstests;

import java.io.File;
import java.util.concurrent.TimeUnit;
import org.junit.Test;
import org.neo4j.helper.StressTestingHelper;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.pagecache.stress.Conditions;
import org.neo4j.io.pagecache.stress.PageCacheStressTest;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;

public class PageCacheStressTesting {
    @Test
    public void shouldBehaveCorrectlyUnderStress() throws Exception {
        int durationInMinutes = Integer.parseInt(StressTestingHelper.fromEnv("PAGE_CACHE_STRESS_DURATION", "1"));
        int numberOfPages = Integer.parseInt(StressTestingHelper.fromEnv("PAGE_CACHE_STRESS_NUMBER_OF_PAGES", "10000"));
        int numberOfThreads = Integer.parseInt(StressTestingHelper.fromEnv("PAGE_CACHE_STRESS_NUMBER_OF_THREADS", "8"));
        int numberOfCachePages = Integer.parseInt(StressTestingHelper.fromEnv("PAGE_CACHE_STRESS_NUMBER_OF_CACHE_PAGES", "1000"));
        File baseDir = new File(StressTestingHelper.fromEnv("PAGE_CACHE_STRESS_WORKING_DIRECTORY", System.getProperty("java.io.tmpdir")));
        File workingDirectory = new File(baseDir, "working");
        DefaultPageCacheTracer monitor = new DefaultPageCacheTracer();
        PageCacheStressTest runner = new PageCacheStressTest.Builder().with(Conditions.timePeriod((int)durationInMinutes, (TimeUnit)TimeUnit.MINUTES)).withNumberOfPages(numberOfPages).withNumberOfThreads(numberOfThreads).withNumberOfCachePages(numberOfCachePages).withWorkingDirectory(StressTestingHelper.ensureExistsAndEmpty(workingDirectory)).with((PageCacheTracer)monitor).build();
        runner.run();
        long faults = monitor.faults();
        long evictions = monitor.evictions();
        long pins = monitor.pins();
        long unpins = monitor.unpins();
        long flushes = monitor.flushes();
        System.out.printf(" - page faults: %d%n - evictions: %d%n - pins: %d%n - unpins: %d%n - flushes: %d%n", faults, evictions, pins, unpins, flushes);
        FileUtils.deleteRecursively((File)workingDirectory);
    }
}

