/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.stresstests.transaction.checkpoint;

import java.io.File;
import java.util.concurrent.TimeUnit;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helper.StressTestingHelper;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.logging.NullLogService;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.stresstests.transaction.checkpoint.NodeCountInputs;
import org.neo4j.kernel.stresstests.transaction.checkpoint.TransactionThroughputChecker;
import org.neo4j.kernel.stresstests.transaction.checkpoint.mutation.RandomMutationFactory;
import org.neo4j.kernel.stresstests.transaction.checkpoint.tracers.TimerTransactionTracer;
import org.neo4j.kernel.stresstests.transaction.checkpoint.workload.Workload;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.scheduler.JobSchedulerAdapter;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.unsafe.impl.batchimport.AdditionalInitialIds;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.ImportLogic;
import org.neo4j.unsafe.impl.batchimport.ParallelBatchImporter;
import org.neo4j.unsafe.impl.batchimport.input.Input;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionMonitors;

public class CheckPointingLogRotationStressTesting {
    private static final String DEFAULT_DURATION_IN_MINUTES = "5";
    private static final String DEFAULT_STORE_DIR = new File(System.getProperty("java.io.tmpdir"), "store").getPath();
    private static final String DEFAULT_NODE_COUNT = "100000";
    private static final String DEFAULT_WORKER_THREADS = "16";
    private static final String DEFAULT_PAGE_CACHE_MEMORY = "4g";
    private static final int CHECK_POINT_INTERVAL_MINUTES = 1;
    private JobScheduler jobScheduler = new JobSchedulerAdapter(){

        public JobScheduler.JobHandle schedule(JobScheduler.Group group, Runnable job) {
            return new JobScheduler.JobHandle(){

                public void cancel(boolean mayInterruptIfRunning) {
                }

                public void waitTermination() {
                }
            };
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldBehaveCorrectlyUnderStress() throws Throwable {
        long durationInMinutes = Long.parseLong(StressTestingHelper.fromEnv("CHECK_POINT_LOG_ROTATION_STRESS_DURATION", DEFAULT_DURATION_IN_MINUTES));
        File storeDir = new File(StressTestingHelper.fromEnv("CHECK_POINT_LOG_ROTATION_STORE_DIRECTORY", DEFAULT_STORE_DIR));
        long nodeCount = Long.parseLong(StressTestingHelper.fromEnv("CHECK_POINT_LOG_ROTATION_NODE_COUNT", DEFAULT_NODE_COUNT));
        int threads = Integer.parseInt(StressTestingHelper.fromEnv("CHECK_POINT_LOG_ROTATION_WORKER_THREADS", DEFAULT_WORKER_THREADS));
        String pageCacheMemory = StressTestingHelper.fromEnv("CHECK_POINT_LOG_ROTATION_PAGE_CACHE_MEMORY", DEFAULT_PAGE_CACHE_MEMORY);
        System.out.println("1/6\tBuilding initial store...");
        try (DefaultFileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();){
            Config dbConfig = Config.defaults();
            new ParallelBatchImporter(StressTestingHelper.ensureExistsAndEmpty(storeDir), (FileSystemAbstraction)fileSystem, null, Configuration.DEFAULT, (LogService)NullLogService.getInstance(), ExecutionMonitors.defaultVisible((JobScheduler)this.jobScheduler), AdditionalInitialIds.EMPTY, dbConfig, RecordFormatSelector.selectForConfig((Config)dbConfig, (LogProvider)NullLogProvider.getInstance()), ImportLogic.NO_MONITOR).doImport((Input)new NodeCountInputs(nodeCount));
        }
        System.out.println("2/6\tStarting database...");
        GraphDatabaseBuilder builder = new TestGraphDatabaseFactory().newEmbeddedDatabaseBuilder(storeDir);
        GraphDatabaseService db = builder.setConfig(GraphDatabaseSettings.pagecache_memory, pageCacheMemory).setConfig(GraphDatabaseSettings.keep_logical_logs, "false").setConfig(GraphDatabaseSettings.check_point_interval_time, "1m").setConfig(GraphDatabaseFacadeFactory.Configuration.tracer, "timer").newGraphDatabase();
        System.out.println("3/6\tWarm up db...");
        try (Workload workload = new Workload(db, RandomMutationFactory.defaultRandomMutation(nodeCount, db), threads);){
            long warmUpTimeMillis = TimeUnit.SECONDS.toMillis(2L);
            workload.run(warmUpTimeMillis, Workload.TransactionThroughput.NONE);
        }
        System.out.println("4/6\tStarting workload...");
        TransactionThroughputChecker throughput = new TransactionThroughputChecker();
        try (Workload workload = new Workload(db, RandomMutationFactory.defaultRandomMutation(nodeCount, db), threads);){
            workload.run(TimeUnit.MINUTES.toMillis(durationInMinutes), throughput);
        }
        System.out.println("5/6\tShutting down...");
        db.shutdown();
        try {
            System.out.println("6/6\tPrinting stats and recorded timings...");
            TimerTransactionTracer.printStats(System.out);
            throughput.assertThroughput(System.out);
        }
        finally {
            System.out.println("Done.");
        }
        FileUtils.deleteRecursively((File)storeDir);
    }
}

