/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.stresstests.transaction.checkpoint;

import java.util.function.ToIntFunction;
import org.neo4j.unsafe.impl.batchimport.GeneratingInputIterator;
import org.neo4j.unsafe.impl.batchimport.InputIterable;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdMapper;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdMappers;
import org.neo4j.unsafe.impl.batchimport.input.Collector;
import org.neo4j.unsafe.impl.batchimport.input.Collectors;
import org.neo4j.unsafe.impl.batchimport.input.Group;
import org.neo4j.unsafe.impl.batchimport.input.Input;
import org.neo4j.unsafe.impl.batchimport.input.Inputs;
import org.neo4j.values.storable.Value;

public class NodeCountInputs
implements Input {
    private static final Object[] properties = new Object[]{"a", 10, "b", 10, "c", 10, "d", 10, "e", 10, "f", 10, "g", 10, "h", 10, "i", 10, "j", 10, "k", 10, "l", 10, "m", 10, "o", 10, "p", 10, "q", 10, "r", 10, "s", 10};
    private static final String[] labels = new String[]{"a", "b", "c", "d"};
    private final long nodeCount;
    private final Collector bad = Collectors.silentBadCollector((long)0L);

    public NodeCountInputs(long nodeCount) {
        this.nodeCount = nodeCount;
    }

    public InputIterable nodes() {
        return InputIterable.replayable(() -> new GeneratingInputIterator(this.nodeCount, 1000, batch -> null, (state, visitor, id) -> {
            visitor.id((Object)id, Group.GLOBAL);
            visitor.labels(labels);
            for (int i = 0; i < properties.length; ++i) {
                visitor.property((String)properties[i++], properties[i]);
            }
        }, 0L));
    }

    public InputIterable relationships() {
        return GeneratingInputIterator.EMPTY_ITERABLE;
    }

    public IdMapper idMapper(NumberArrayFactory numberArrayFactory) {
        return IdMappers.actual();
    }

    public Collector badCollector() {
        return this.bad;
    }

    public Input.Estimates calculateEstimates(ToIntFunction<Value[]> valueSizeCalculator) {
        return Inputs.knownEstimates((long)this.nodeCount, (long)0L, (long)(this.nodeCount * (long)properties.length / 2L), (long)0L, (long)(this.nodeCount * (long)properties.length / 2L * 8L), (long)0L, (long)(this.nodeCount * (long)labels.length));
    }
}

