/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.stresstests.transaction.checkpoint;

import java.io.PrintStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.neo4j.kernel.stresstests.transaction.checkpoint.workload.Workload;

public class TransactionThroughputChecker
implements Workload.TransactionThroughput {
    private final DateFormat dateFormat = TransactionThroughputChecker.newDateFormat();
    private final Map<String, Double> reports = new LinkedHashMap<String, Double>();

    @Override
    public void report(long transactions, long timeSlotMillis) {
        long elapsedSeconds = TimeUnit.MILLISECONDS.toSeconds(timeSlotMillis);
        double throughput = (double)transactions / (double)elapsedSeconds;
        String timestamp = this.currentTime();
        this.reports.put(timestamp, throughput);
    }

    public void assertThroughput(PrintStream out) {
        if (this.reports.isEmpty()) {
            out.println("no reports");
            return;
        }
        this.printThroughputReports(out);
        double average = TransactionThroughputChecker.average(this.reports.values());
        out.println("Average throughput (tx/s): " + average);
        double stdDeviation = TransactionThroughputChecker.stdDeviation(this.reports.values());
        out.println("Standard deviation (tx/s): " + stdDeviation);
        double twoStdDeviations = stdDeviation * 2.0;
        out.println("Two standard deviations (tx/s): " + twoStdDeviations);
        int inOneStdDeviationRange = 0;
        int inTwoStdDeviationRange = 0;
        for (double report : this.reports.values()) {
            if (Math.abs(average - report) <= stdDeviation) {
                ++inOneStdDeviationRange;
                ++inTwoStdDeviationRange;
                continue;
            }
            if (Math.abs(average - report) <= twoStdDeviations) {
                out.println("Outside _one_ std deviation range: " + report);
                ++inTwoStdDeviationRange;
                continue;
            }
            out.println("Outside _two_ std deviation range: " + report);
        }
        int inOneStdDeviationRangePercentage = (int)((double)inOneStdDeviationRange * 100.0 / (double)this.reports.size());
        System.out.println("Percentage inside one std deviation is: " + inOneStdDeviationRangePercentage);
        Assert.assertTrue((String)("Assumption is that at least 60 percent should be in one std deviation (" + stdDeviation + ") range from the average (" + average + ") "), (inOneStdDeviationRangePercentage >= 60 ? 1 : 0) != 0);
        int inTwoStdDeviationRangePercentage = (int)((double)inTwoStdDeviationRange * 100.0 / (double)this.reports.size());
        System.out.println("Percentage inside two std deviations is: " + inTwoStdDeviationRangePercentage);
        Assert.assertTrue((String)("Assumption is that at least 90 percent should be in two std deviations (" + twoStdDeviations + ") range from the average (" + average + ") "), (inTwoStdDeviationRangePercentage >= 90 ? 1 : 0) != 0);
    }

    private void printThroughputReports(PrintStream out) {
        out.println("Throughput reports (tx/s):");
        for (Map.Entry<String, Double> entry : this.reports.entrySet()) {
            out.println("\t" + entry.getKey() + "  " + entry.getValue());
        }
        out.println();
    }

    private static double average(Collection<Double> values) {
        double sum = 0.0;
        for (Double value : values) {
            sum += value.doubleValue();
        }
        return sum / (double)values.size();
    }

    private static double stdDeviation(Collection<Double> values) {
        double average = TransactionThroughputChecker.average(values);
        double powerSum = 0.0;
        for (double value : values) {
            powerSum += Math.pow(value - average, 2.0);
        }
        return Math.sqrt(powerSum / (double)values.size());
    }

    private String currentTime() {
        return this.dateFormat.format(new Date());
    }

    private static DateFormat newDateFormat() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSZ");
        TimeZone timeZone = TimeZone.getTimeZone("UTC");
        format.setTimeZone(timeZone);
        return format;
    }
}

