/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.stresstests.transaction.checkpoint.mutation;

import java.util.concurrent.ThreadLocalRandom;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.stresstests.transaction.checkpoint.mutation.Mutation;
import org.neo4j.kernel.stresstests.transaction.checkpoint.mutation.RandomMutation;

class SimpleRandomMutation
implements RandomMutation {
    private final long nodeCount;
    private final GraphDatabaseService db;
    private final Mutation rareMutation;
    private final Mutation commonMutation;
    private static String[] NAMES = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s"};

    SimpleRandomMutation(long nodeCount, GraphDatabaseService db, Mutation rareMutation, Mutation commonMutation) {
        this.nodeCount = nodeCount;
        this.db = db;
        this.rareMutation = rareMutation;
        this.commonMutation = commonMutation;
    }

    @Override
    public void perform() {
        ThreadLocalRandom rng = ThreadLocalRandom.current();
        long nodeId = rng.nextLong(this.nodeCount);
        String value = NAMES[rng.nextInt(NAMES.length)];
        if (rng.nextDouble() < 0.01) {
            this.rareMutation.perform(nodeId, value);
        } else {
            this.commonMutation.perform(nodeId, value);
        }
    }
}

