/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.stresstests.transaction.checkpoint.tracers;

import java.io.PrintStream;
import java.util.concurrent.TimeUnit;
import org.HdrHistogram.Histogram;
import org.neo4j.kernel.impl.transaction.tracing.CheckPointTracer;
import org.neo4j.kernel.impl.transaction.tracing.CommitEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogAppendEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogCheckPointEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogForceEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogForceWaitEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogRotateEvent;
import org.neo4j.kernel.impl.transaction.tracing.SerializeTransactionEvent;
import org.neo4j.kernel.impl.transaction.tracing.StoreApplyEvent;
import org.neo4j.kernel.impl.transaction.tracing.TransactionEvent;
import org.neo4j.kernel.impl.transaction.tracing.TransactionTracer;

public class TimerTransactionTracer
implements TransactionTracer,
CheckPointTracer {
    private static volatile long logForceBegin;
    private static volatile long logCheckPointBegin;
    private static volatile long logRotateBegin;
    private static final Histogram logForceTimes;
    private static final Histogram logRotateTimes;
    private static final Histogram logCheckPointTimes;
    private static final LogForceEvent LOG_FORCE_EVENT;
    private static final LogCheckPointEvent LOG_CHECK_POINT_EVENT;
    private static final LogRotateEvent LOG_ROTATE_EVENT;
    private static final LogAppendEvent LOG_APPEND_EVENT;
    private static final CommitEvent COMMIT_EVENT;
    private static final TransactionEvent TRANSACTION_EVENT;

    public static void printStats(PrintStream out) {
        TimerTransactionTracer.printStat(out, "Log force millisecond percentiles:", logForceTimes);
        TimerTransactionTracer.printStat(out, "Log rotate millisecond percentiles:", logRotateTimes);
        TimerTransactionTracer.printStat(out, "Log check point millisecond percentiles:", logCheckPointTimes);
    }

    private static void printStat(PrintStream out, String message, Histogram histogram) {
        out.println(message);
        histogram.outputPercentileDistribution(out, Double.valueOf(1000000.0));
        out.println();
    }

    public TransactionEvent beginTransaction() {
        return TRANSACTION_EVENT;
    }

    public LogCheckPointEvent beginCheckPoint() {
        logCheckPointBegin = System.nanoTime();
        return LOG_CHECK_POINT_EVENT;
    }

    static {
        logForceTimes = new Histogram(1000L, TimeUnit.MINUTES.toNanos(45L), 0);
        logRotateTimes = new Histogram(1000L, TimeUnit.MINUTES.toNanos(45L), 0);
        logCheckPointTimes = new Histogram(1000L, TimeUnit.MINUTES.toNanos(45L), 0);
        LOG_FORCE_EVENT = new LogForceEvent(){

            public void close() {
                long elapsedNanos = System.nanoTime() - logForceBegin;
                logForceTimes.recordValue(elapsedNanos);
            }
        };
        LOG_CHECK_POINT_EVENT = new LogCheckPointEvent(){

            public LogForceWaitEvent beginLogForceWait() {
                return LogForceWaitEvent.NULL;
            }

            public LogForceEvent beginLogForce() {
                logForceBegin = System.nanoTime();
                return LOG_FORCE_EVENT;
            }

            public void close() {
                long elapsedNanos = System.nanoTime() - logCheckPointBegin;
                logCheckPointTimes.recordValue(elapsedNanos);
            }
        };
        LOG_ROTATE_EVENT = new LogRotateEvent(){

            public void close() {
                long elapsedNanos = System.nanoTime() - logRotateBegin;
                logRotateTimes.recordValue(elapsedNanos);
            }
        };
        LOG_APPEND_EVENT = new LogAppendEvent(){

            public void close() {
            }

            public void setLogRotated(boolean b) {
            }

            public LogRotateEvent beginLogRotate() {
                logRotateBegin = System.nanoTime();
                return LOG_ROTATE_EVENT;
            }

            public SerializeTransactionEvent beginSerializeTransaction() {
                return SerializeTransactionEvent.NULL;
            }

            public LogForceWaitEvent beginLogForceWait() {
                return LogForceWaitEvent.NULL;
            }

            public LogForceEvent beginLogForce() {
                logForceBegin = System.nanoTime();
                return LOG_FORCE_EVENT;
            }
        };
        COMMIT_EVENT = new CommitEvent(){

            public void close() {
            }

            public LogAppendEvent beginLogAppend() {
                return LOG_APPEND_EVENT;
            }

            public StoreApplyEvent beginStoreApply() {
                return StoreApplyEvent.NULL;
            }
        };
        TRANSACTION_EVENT = new TransactionEvent(){

            public void setSuccess(boolean b) {
            }

            public void setFailure(boolean b) {
            }

            public CommitEvent beginCommitEvent() {
                return COMMIT_EVENT;
            }

            public void close() {
            }

            public void setTransactionWriteState(String transactionWriteState) {
            }

            public void setReadOnly(boolean b) {
            }
        };
    }
}

