/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.stresstests.transaction.checkpoint.workload;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.kernel.stresstests.transaction.checkpoint.workload.Worker;

class SyncMonitor
implements Worker.Monitor {
    private final AtomicBoolean stopSignal = new AtomicBoolean();
    private final AtomicLong transactionCounter = new AtomicLong();
    private final CountDownLatch stopLatch;

    SyncMonitor(int threads) {
        this.stopLatch = new CountDownLatch(threads);
    }

    @Override
    public void transactionCompleted() {
        this.transactionCounter.incrementAndGet();
    }

    @Override
    public boolean stop() {
        return this.stopSignal.get();
    }

    @Override
    public void done() {
        this.stopLatch.countDown();
    }

    public long transactions() {
        return this.transactionCounter.get();
    }

    public void stopAndWaitWorkers() throws InterruptedException {
        this.stopSignal.set(true);
        this.stopLatch.await();
    }
}

