/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.stresstests.transaction.checkpoint.workload;

import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.stresstests.transaction.checkpoint.mutation.RandomMutation;

class Worker
implements Runnable {
    private final GraphDatabaseService db;
    private final RandomMutation randomMutation;
    private final Monitor monitor;
    private final int numOpsPerTx;

    Worker(GraphDatabaseService db, RandomMutation randomMutation, Monitor monitor, int numOpsPerTx) {
        this.db = db;
        this.randomMutation = randomMutation;
        this.monitor = monitor;
        this.numOpsPerTx = numOpsPerTx;
    }

    @Override
    public void run() {
        do {
            try (Transaction tx2 = this.db.beginTx();){
                for (int i = 0; i < this.numOpsPerTx; ++i) {
                    this.randomMutation.perform();
                }
                tx2.success();
            }
            catch (DeadlockDetectedException tx2) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.monitor.transactionCompleted();
        } while (!this.monitor.stop());
        this.monitor.done();
    }

    static interface Monitor {
        public void transactionCompleted();

        public boolean stop();

        public void done();
    }
}

