/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.stresstests.transaction.checkpoint.workload;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Resource;
import org.neo4j.kernel.stresstests.transaction.checkpoint.mutation.RandomMutation;
import org.neo4j.kernel.stresstests.transaction.checkpoint.workload.SyncMonitor;
import org.neo4j.kernel.stresstests.transaction.checkpoint.workload.Worker;

public class Workload
implements Resource {
    private final int threads;
    private final SyncMonitor sync;
    private final Worker worker;
    private final ExecutorService executor;

    public Workload(GraphDatabaseService db, RandomMutation randomMutation, int threads) {
        this.threads = threads;
        this.sync = new SyncMonitor(threads);
        this.worker = new Worker(db, randomMutation, this.sync, 100);
        this.executor = Executors.newCachedThreadPool();
    }

    public void run(long runningTimeMillis, TransactionThroughput throughput) throws InterruptedException {
        for (int i = 0; i < this.threads; ++i) {
            this.executor.submit(this.worker);
        }
        TimeUnit.SECONDS.sleep(20L);
        long now = System.currentTimeMillis();
        long previousReportTime = System.currentTimeMillis();
        long finishLine = runningTimeMillis + now;
        long sampleRate = TimeUnit.SECONDS.toMillis(10L);
        long lastReport = sampleRate + now;
        long previousTransactionCount = this.sync.transactions();
        Thread.sleep(sampleRate);
        do {
            if (lastReport <= (now = System.currentTimeMillis())) {
                long currentTransactionCount = this.sync.transactions();
                long diff = currentTransactionCount - previousTransactionCount;
                throughput.report(diff, now - previousReportTime);
                previousReportTime = now;
                previousTransactionCount = currentTransactionCount;
                lastReport = sampleRate + now;
                Thread.sleep(sampleRate);
                continue;
            }
            Thread.sleep(10L);
        } while (now < finishLine);
        if (lastReport < now) {
            long diff = this.sync.transactions() - previousTransactionCount;
            throughput.report(diff, now - previousReportTime);
        }
        this.sync.stopAndWaitWorkers();
    }

    public void close() {
        try {
            this.executor.shutdown();
            this.executor.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static interface TransactionThroughput {
        public static final TransactionThroughput NONE = (transactions, timeSlotMillis) -> {};

        public void report(long var1, long var3);
    }
}

