/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.stresstests.transaction.log;

import java.io.File;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.function.Suppliers;
import org.neo4j.helper.StressTestingHelper;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.impl.transaction.log.stresstest.TransactionAppenderStressTest;

public class TransactionAppenderStressTesting {
    private static final String DEFAULT_DURATION_IN_MINUTES = "5";
    private static final String DEFAULT_WORKING_DIR = new File(System.getProperty("java.io.tmpdir"), "working").getPath();
    private static final String DEFAULT_NUM_THREADS = "10";

    @Test
    public void shouldBehaveCorrectlyUnderStress() throws Throwable {
        int durationInMinutes = Integer.parseInt(StressTestingHelper.fromEnv("TX_APPENDER_STRESS_DURATION", DEFAULT_DURATION_IN_MINUTES));
        File workingDirectory = new File(StressTestingHelper.fromEnv("TX_APPENDER_WORKING_DIRECTORY", DEFAULT_WORKING_DIR));
        int threads = Integer.parseInt(StressTestingHelper.fromEnv("TX_APPENDER_NUM_THREADS", DEFAULT_NUM_THREADS));
        Callable runner = new TransactionAppenderStressTest.Builder().with(Suppliers.untilTimeExpired((long)durationInMinutes, (TimeUnit)TimeUnit.MINUTES)).withWorkingDirectory(StressTestingHelper.ensureExistsAndEmpty(workingDirectory)).withNumThreads(threads).build();
        long appendedTxs = (Long)runner.call();
        Assert.assertEquals((long)new TransactionAppenderStressTest.TransactionIdChecker(workingDirectory).parseAllTxLogs(), (long)appendedTxs);
        FileUtils.deleteRecursively((File)workingDirectory);
    }
}

