/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.token;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.token.TokenRegistry;
import org.neo4j.token.api.NamedToken;
import org.neo4j.token.api.NonUniqueTokenException;

class TokenRegistryTest {
    private static final String INBOUND2_TYPE = "inbound2";
    private static final String INBOUND1_TYPE = "inbound1";
    private TokenRegistry registry;

    TokenRegistryTest() {
    }

    @BeforeEach
    void setUp() {
        this.registry = new TokenRegistry("testType");
    }

    @Test
    void puttingPublicTokenWithDuplicateNamedNotAllowed() {
        this.registry.put(new NamedToken(INBOUND1_TYPE, 1));
        this.registry.put(new NamedToken(INBOUND2_TYPE, 2));
        NamedToken token = new NamedToken(INBOUND1_TYPE, 3);
        NonUniqueTokenException exception = (NonUniqueTokenException)org.junit.jupiter.api.Assertions.assertThrows(NonUniqueTokenException.class, () -> this.registry.put(token));
        Assertions.assertThat((String)exception.getMessage()).contains(new CharSequence[]{String.format("The testType %s is not unique", token)});
    }

    @Test
    void puttingInternalTokenWithDuplicateNamedNotAllowed() {
        this.registry.put(new NamedToken(INBOUND1_TYPE, 1, true));
        this.registry.put(new NamedToken(INBOUND2_TYPE, 2, true));
        NamedToken token = new NamedToken(INBOUND1_TYPE, 3, true);
        NonUniqueTokenException exception = (NonUniqueTokenException)org.junit.jupiter.api.Assertions.assertThrows(NonUniqueTokenException.class, () -> this.registry.put(token));
        Assertions.assertThat((String)exception.getMessage()).contains(new CharSequence[]{String.format("The testType %s is not unique", token)});
    }

    @Test
    void mustKeepOriginalPublicTokenWhenAddDuplicate() {
        this.registry.put(new NamedToken(INBOUND1_TYPE, 1));
        this.registry.put(new NamedToken(INBOUND2_TYPE, 2));
        org.junit.jupiter.api.Assertions.assertThrows(NonUniqueTokenException.class, () -> this.registry.put(new NamedToken(INBOUND1_TYPE, 3)));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.registry.getId(INBOUND1_TYPE));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)this.registry.getId(INBOUND2_TYPE));
        org.junit.jupiter.api.Assertions.assertNull((Object)this.registry.getToken(3));
        org.junit.jupiter.api.Assertions.assertNull((Object)this.registry.getTokenInternal(3));
    }

    @Test
    void mustKeepOriginalInternalTokenWhenAddDuplicate() {
        this.registry.put(new NamedToken(INBOUND1_TYPE, 1, true));
        this.registry.put(new NamedToken(INBOUND2_TYPE, 2, true));
        org.junit.jupiter.api.Assertions.assertThrows(NonUniqueTokenException.class, () -> this.registry.put(new NamedToken(INBOUND1_TYPE, 3, true)));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.registry.getIdInternal(INBOUND1_TYPE));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)this.registry.getIdInternal(INBOUND2_TYPE));
        org.junit.jupiter.api.Assertions.assertNull((Object)this.registry.getTokenInternal(3));
        org.junit.jupiter.api.Assertions.assertNull((Object)this.registry.getToken(3));
    }

    @Test
    void putAllMustThrowOnDuplicateNameInTokensAdded() {
        org.junit.jupiter.api.Assertions.assertThrows(NonUniqueTokenException.class, () -> this.registry.putAll(Arrays.asList(new NamedToken(INBOUND1_TYPE, 1), new NamedToken(INBOUND1_TYPE, 2))));
    }

    @Test
    void putAllMustNotThrowWhenPublicAndInternalTokenHaveSameName() {
        this.registry.putAll(Arrays.asList(new NamedToken(INBOUND1_TYPE, 1), new NamedToken(INBOUND1_TYPE, 2, true)));
        Assertions.assertThat((int)this.registry.getId(INBOUND1_TYPE)).isEqualTo(1);
        Assertions.assertThat((int)this.registry.getIdInternal(INBOUND1_TYPE)).isEqualTo(2);
        Assertions.assertThat((Object)this.registry.getToken(1)).isEqualTo((Object)new NamedToken(INBOUND1_TYPE, 1));
        Assertions.assertThat((Object)this.registry.getTokenInternal(1)).isNull();
        Assertions.assertThat((Object)this.registry.getToken(2)).isNull();
        Assertions.assertThat((Object)this.registry.getTokenInternal(2)).isEqualTo((Object)new NamedToken(INBOUND1_TYPE, 2, true));
    }

    @Test
    void putAllMustThrowOnDuplicateIdInTokensAdded() {
        org.junit.jupiter.api.Assertions.assertThrows(NonUniqueTokenException.class, () -> this.registry.putAll(Arrays.asList(new NamedToken(INBOUND1_TYPE, 1), new NamedToken(INBOUND2_TYPE, 1))));
    }

    @Test
    void putAllMustThrowOnDuplicateIdInTokensAddedEvenAcrossPublicAndInternalTokens() {
        org.junit.jupiter.api.Assertions.assertThrows(NonUniqueTokenException.class, () -> this.registry.putAll(Arrays.asList(new NamedToken(INBOUND1_TYPE, 1), new NamedToken(INBOUND2_TYPE, 1, true))));
    }

    @Test
    void setInitialTokensMustThrowOnDuplicateNameInTokensAdded() {
        NamedToken first = new NamedToken(INBOUND1_TYPE, 1);
        NamedToken second = new NamedToken(INBOUND1_TYPE, 2);
        NonUniqueTokenException e = (NonUniqueTokenException)org.junit.jupiter.api.Assertions.assertThrows(NonUniqueTokenException.class, () -> this.registry.setInitialTokens(Arrays.asList(first, second)));
        Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{first.toString()});
    }

    @Test
    void setInitialTokensMustNotThrowWhenPublicAndInternalTokenHasSameName() {
        this.registry.setInitialTokens(Arrays.asList(new NamedToken(INBOUND1_TYPE, 1), new NamedToken(INBOUND1_TYPE, 2, true)));
    }

    @Test
    void setInitialTokensMustThrowOnDuplicateIdInTokensAdded() {
        org.junit.jupiter.api.Assertions.assertThrows(NonUniqueTokenException.class, () -> this.registry.setInitialTokens(Arrays.asList(new NamedToken(INBOUND1_TYPE, 1), new NamedToken(INBOUND2_TYPE, 1))));
    }

    @Test
    void setInitialTokensMustThrowOnDuplicateIdInTokensAddedEvenAcrossPublicAndInternalTokens() {
        org.junit.jupiter.api.Assertions.assertThrows(NonUniqueTokenException.class, () -> this.registry.setInitialTokens(Arrays.asList(new NamedToken(INBOUND1_TYPE, 1), new NamedToken(INBOUND2_TYPE, 1, true))));
    }

    @Test
    void putAllMustThrowOnDuplicateNameWithExistingToken() {
        this.registry.put(new NamedToken(INBOUND1_TYPE, 1));
        org.junit.jupiter.api.Assertions.assertThrows(NonUniqueTokenException.class, () -> this.registry.putAll(Collections.singletonList(new NamedToken(INBOUND1_TYPE, 2))));
    }

    @Test
    void putAllMustNotThrowWhenInternalTokenDuplicatesNameOfPublicToken() {
        this.registry.put(new NamedToken(INBOUND1_TYPE, 1));
        this.registry.putAll(Collections.singletonList(new NamedToken(INBOUND1_TYPE, 2, true)));
    }

    @Test
    void putAllMustNotThrowWhenPublicTokenDuplicatesNameOfInternalToken() {
        this.registry.put(new NamedToken(INBOUND1_TYPE, 1, true));
        this.registry.putAll(Collections.singletonList(new NamedToken(INBOUND1_TYPE, 2)));
    }

    @Test
    void putAllMustThrowOnDuplicateIdWithExistingToken() {
        this.registry.put(new NamedToken(INBOUND1_TYPE, 1));
        org.junit.jupiter.api.Assertions.assertThrows(NonUniqueTokenException.class, () -> this.registry.putAll(Collections.singletonList(new NamedToken(INBOUND2_TYPE, 1))));
        Assertions.assertThat((Object)this.registry.getToken(1)).isEqualTo((Object)new NamedToken(INBOUND1_TYPE, 1));
        Assertions.assertThat((int)this.registry.getId(INBOUND1_TYPE)).isEqualTo(1);
        Assertions.assertThat((int)this.registry.getId(INBOUND2_TYPE)).isEqualTo(-1);
    }

    @Test
    void putAllMustThrowOnDuplicateIdWithExistingTokenEvenAcrossPublicAndInternalTokens() {
        this.registry.put(new NamedToken(INBOUND1_TYPE, 1));
        org.junit.jupiter.api.Assertions.assertThrows(NonUniqueTokenException.class, () -> this.registry.putAll(Collections.singletonList(new NamedToken(INBOUND2_TYPE, 1, true))));
        Assertions.assertThat((Object)this.registry.getToken(1)).isEqualTo((Object)new NamedToken(INBOUND1_TYPE, 1));
        Assertions.assertThat((int)this.registry.getId(INBOUND1_TYPE)).isEqualTo(1);
        Assertions.assertThat((int)this.registry.getId(INBOUND2_TYPE)).isEqualTo(-1);
        Assertions.assertThat((int)this.registry.getIdInternal(INBOUND1_TYPE)).isEqualTo(-1);
        Assertions.assertThat((int)this.registry.getIdInternal(INBOUND2_TYPE)).isEqualTo(-1);
    }

    @Test
    void putAllMustThrowOnDuplicateIdWithExistingTokenEvenAcrossInternalAndPublicTokens() {
        this.registry.put(new NamedToken(INBOUND1_TYPE, 1, true));
        org.junit.jupiter.api.Assertions.assertThrows(NonUniqueTokenException.class, () -> this.registry.putAll(Collections.singletonList(new NamedToken(INBOUND2_TYPE, 1))));
        Assertions.assertThat((Object)this.registry.getTokenInternal(1)).isEqualTo((Object)new NamedToken(INBOUND1_TYPE, 1, true));
        Assertions.assertThat((Object)this.registry.getToken(1)).isNull();
        Assertions.assertThat((int)this.registry.getId(INBOUND1_TYPE)).isEqualTo(-1);
        Assertions.assertThat((int)this.registry.getId(INBOUND2_TYPE)).isEqualTo(-1);
        Assertions.assertThat((int)this.registry.getIdInternal(INBOUND1_TYPE)).isEqualTo(1);
        Assertions.assertThat((int)this.registry.getIdInternal(INBOUND2_TYPE)).isEqualTo(-1);
    }

    @Test
    void setInitialTokensMustNotThrowOnDuplicateWithExistingToken() {
        this.registry.put(new NamedToken(INBOUND1_TYPE, 1));
        this.registry.setInitialTokens(Collections.singletonList(new NamedToken(INBOUND1_TYPE, 1)));
    }

    @Test
    void getIdMustNotFindInternalTokens() {
        this.registry.put(new NamedToken(INBOUND1_TYPE, 1, true));
        Assertions.assertThat((int)this.registry.getId(INBOUND1_TYPE)).isEqualTo(-1);
    }

    @Test
    void getIdInternalMustFindInternalTokens() {
        this.registry.put(new NamedToken(INBOUND1_TYPE, 1, true));
        Assertions.assertThat((int)this.registry.getIdInternal(INBOUND1_TYPE)).isEqualTo(1);
    }

    @Test
    void getIdInternalMustNotFindPublicTokens() {
        this.registry.put(new NamedToken(INBOUND1_TYPE, 1));
        Assertions.assertThat((int)this.registry.getIdInternal(INBOUND1_TYPE)).isEqualTo(-1);
    }

    @Test
    void getTokenMustNotFindInternalTokens() {
        this.registry.put(new NamedToken(INBOUND1_TYPE, 1, true));
        Assertions.assertThat((Object)this.registry.getToken(1)).isNull();
    }

    @Test
    void getTokenInternalMustFindInternalTokens() {
        this.registry.put(new NamedToken(INBOUND1_TYPE, 1, true));
        Assertions.assertThat((Object)this.registry.getTokenInternal(1)).isEqualTo((Object)new NamedToken(INBOUND1_TYPE, 1, true));
    }

    @Test
    void getTokenInternalMustNotFindPublicTokens() {
        this.registry.put(new NamedToken(INBOUND1_TYPE, 1));
        Assertions.assertThat((Object)this.registry.getTokenInternal(1)).isNull();
    }

    @Test
    void allTokensMustIncludePublicTokensButNotIncludeInternalTokens() {
        this.registry.putAll(Arrays.asList(new NamedToken(INBOUND1_TYPE, 1), new NamedToken(INBOUND1_TYPE, 2, true), new NamedToken(INBOUND2_TYPE, 3), new NamedToken(INBOUND2_TYPE, 4, true)));
        Collection tokens = this.registry.allTokens();
        Assertions.assertThat((Collection)tokens).contains((Object[])new NamedToken[]{new NamedToken(INBOUND1_TYPE, 1), new NamedToken(INBOUND2_TYPE, 3)});
    }

    @Test
    void allInternalTokensMustIncludeInternalTokensButNotIncludePublicTokens() {
        this.registry.putAll(Arrays.asList(new NamedToken(INBOUND1_TYPE, 1), new NamedToken(INBOUND1_TYPE, 2, true), new NamedToken(INBOUND2_TYPE, 3), new NamedToken(INBOUND2_TYPE, 4, true)));
        Collection tokens = this.registry.allInternalTokens();
        Assertions.assertThat((Collection)tokens).contains((Object[])new NamedToken[]{new NamedToken(INBOUND1_TYPE, 2, true), new NamedToken(INBOUND2_TYPE, 4, true)});
    }

    @Test
    void sizeMustCountPublicTokensButNotInternalTokens() {
        this.registry.putAll(Arrays.asList(new NamedToken(INBOUND1_TYPE, 1), new NamedToken(INBOUND2_TYPE, 3), new NamedToken(INBOUND2_TYPE, 4, true)));
        Assertions.assertThat((int)this.registry.size()).isEqualTo(2);
    }

    @Test
    void sizeInternalMustCountInternalTokensButNotPublicTokens() {
        this.registry.putAll(Arrays.asList(new NamedToken(INBOUND1_TYPE, 1), new NamedToken(INBOUND1_TYPE, 2, true), new NamedToken(INBOUND2_TYPE, 4, true)));
        Assertions.assertThat((int)this.registry.sizeInternal()).isEqualTo(2);
    }

    @Test
    void puttingInternalTokenBySameNameAsPublicTokenMustNotConflict() {
        this.registry.put(new NamedToken(INBOUND1_TYPE, 1));
        this.registry.put(new NamedToken(INBOUND1_TYPE, 2, true));
    }

    @Test
    void puttingPublicTokenBySameNameAsInternalTokenMustNotConflict() {
        this.registry.put(new NamedToken(INBOUND1_TYPE, 1, true));
        this.registry.put(new NamedToken(INBOUND1_TYPE, 2));
    }

    @Test
    void puttingTwoIdenticalPublicTokensShouldBeIgnored() {
        this.registry.put(new NamedToken(INBOUND1_TYPE, 1));
        this.registry.put(new NamedToken(INBOUND1_TYPE, 1));
    }

    @Test
    void puttingTwoIdenticalInternalTokensShouldBeIgnored() {
        this.registry.put(new NamedToken(INBOUND1_TYPE, 1, true));
        this.registry.put(new NamedToken(INBOUND1_TYPE, 1, true));
    }
}

