/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.internal.dragons;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.unsafe.impl.internal.dragons.MemoryManager;
import org.neo4j.unsafe.impl.internal.dragons.UnsafeUtil;

public class MemoryManagerTest {
    @Test
    public void allocatedPointerMustNotBeNull() throws Exception {
        MemoryManager mman = new MemoryManager(65536L, 8L);
        long address = mman.allocateAligned(8192L);
        Assert.assertThat((Object)address, (Matcher)Matchers.is((Matcher)Matchers.not((Object)0L)));
    }

    @Test
    public void allocatedPointerMustBePageAligned() throws Exception {
        MemoryManager mman = new MemoryManager(65536L, (long)UnsafeUtil.pageSize());
        long address = mman.allocateAligned(8192L);
        Assert.assertThat((Object)(address % (long)UnsafeUtil.pageSize()), (Matcher)Matchers.is((Object)0L));
    }

    @Test
    public void mustBeAbleToAllocatePastMemoryLimit() throws Exception {
        MemoryManager mman = new MemoryManager(8192L, 2L);
        for (int i = 0; i < 4100; ++i) {
            Assert.assertThat((Object)(mman.allocateAligned(1L) % 2L), (Matcher)Matchers.is((Object)0L));
        }
    }
}

