/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.tooling.procedure.visitors;

import java.util.stream.Stream;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.util.SimpleElementVisitor8;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.PerformsWrites;
import org.neo4j.procedure.Procedure;
import org.neo4j.tooling.procedure.messages.CompilationMessage;
import org.neo4j.tooling.procedure.messages.PerformsWriteMisuseError;

public class PerformsWriteMethodVisitor
extends SimpleElementVisitor8<Stream<CompilationMessage>, Void> {
    @Override
    public Stream<CompilationMessage> visitExecutable(ExecutableElement method, Void ignored) {
        Procedure procedure = method.getAnnotation(Procedure.class);
        if (procedure == null) {
            return Stream.of(new PerformsWriteMisuseError(method, "@%s usage error: missing @%s annotation on method", PerformsWrites.class.getSimpleName(), Procedure.class.getSimpleName()));
        }
        if (procedure.mode() != Mode.DEFAULT) {
            return Stream.of(new PerformsWriteMisuseError(method, "@%s usage error: cannot use mode other than Mode.DEFAULT", PerformsWrites.class.getSimpleName()));
        }
        return Stream.empty();
    }
}

