/*
 * Decompiled with CFR 0.152.
 */
package apoc.processor;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Modifier;

public class ExtensionClassWriter {
    private final Filer filer;

    public ExtensionClassWriter(Filer filer) {
        this.filer = filer;
    }

    public void write(List<String> procedureSignatures, List<String> userFunctionSignatures) {
        try {
            JavaFile.builder((String)"apoc", (TypeSpec)this.defineClass(procedureSignatures, userFunctionSignatures)).build().writeTo(this.filer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private TypeSpec defineClass(List<String> procedureSignatures, List<String> userFunctionSignatures) {
        return TypeSpec.classBuilder((String)"ApocSignatures").addModifiers(new Modifier[]{Modifier.PUBLIC}).addField(this.signatureListField("PROCEDURES", procedureSignatures)).addField(this.signatureListField("FUNCTIONS", userFunctionSignatures)).build();
    }

    private FieldSpec signatureListField(String fieldName, List<String> signatures) {
        ParameterizedTypeName fieldType = ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{ClassName.get(String.class)});
        return FieldSpec.builder((TypeName)fieldType, (String)fieldName, (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer(CodeBlock.builder().addStatement(String.format("List.of(%s)", this.placeholders(signatures)), signatures.toArray()).build()).build();
    }

    private String placeholders(List<String> signatures) {
        return signatures.stream().map(ignored -> "$S").collect(Collectors.joining(",\n\t\t"));
    }
}

