/*
 * Decompiled with CFR 0.152.
 */
package apoc.processor;

import apoc.processor.ExtensionClassWriter;
import apoc.processor.SignatureVisitor;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.UserAggregationFunction;
import org.neo4j.procedure.UserFunction;

@SupportedSourceVersion(value=SourceVersion.RELEASE_17)
public class ApocProcessor
extends AbstractProcessor {
    private List<String> procedureSignatures;
    private List<String> userFunctionSignatures;
    private SignatureVisitor signatureVisitor;
    private ExtensionClassWriter extensionClassWriter;

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Set.of(Procedure.class.getName(), UserFunction.class.getName(), UserAggregationFunction.class.getName());
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        this.procedureSignatures = new ArrayList<String>();
        this.userFunctionSignatures = new ArrayList<String>();
        this.extensionClassWriter = new ExtensionClassWriter(processingEnv.getFiler());
        this.signatureVisitor = new SignatureVisitor(processingEnv.getElementUtils(), processingEnv.getMessager());
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        annotations.forEach(annotation -> this.extractSignature((TypeElement)annotation, roundEnv));
        if (roundEnv.processingOver()) {
            this.extensionClassWriter.write(this.procedureSignatures, this.userFunctionSignatures);
        }
        return false;
    }

    private void extractSignature(TypeElement annotation, RoundEnvironment roundEnv) {
        List<String> signatures = this.accumulator(annotation);
        roundEnv.getElementsAnnotatedWith(annotation).forEach(annotatedElement -> signatures.add((String)this.signatureVisitor.visit((Element)annotatedElement)));
    }

    private List<String> accumulator(TypeElement annotation) {
        if (annotation.getQualifiedName().contentEquals(Procedure.class.getName())) {
            return this.procedureSignatures;
        }
        return this.userFunctionSignatures;
    }
}

