/*
 * Decompiled with CFR 0.152.
 */
package apoc.processor;

import apoc.processor.ExtensionClassWriter;
import apoc.processor.SignatureVisitor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.neo4j.kernel.api.QueryLanguage;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.UserAggregationFunction;
import org.neo4j.procedure.UserFunction;

@SupportedSourceVersion(value=SourceVersion.RELEASE_17)
public class ApocProcessor
extends AbstractProcessor {
    private List<Map<String, List<QueryLanguage>>> procedureSignatures;
    private List<Map<String, List<QueryLanguage>>> userFunctionSignatures;
    private SignatureVisitor signatureVisitor;
    private ExtensionClassWriter extensionClassWriter;

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Set.of(Procedure.class.getName(), UserFunction.class.getName(), UserAggregationFunction.class.getName());
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        this.procedureSignatures = new ArrayList<Map<String, List<QueryLanguage>>>();
        this.userFunctionSignatures = new ArrayList<Map<String, List<QueryLanguage>>>();
        this.extensionClassWriter = new ExtensionClassWriter(processingEnv.getFiler());
        this.signatureVisitor = new SignatureVisitor(processingEnv.getElementUtils(), processingEnv.getMessager());
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        annotations.forEach(annotation -> this.extractSignature((TypeElement)annotation, roundEnv));
        ArrayList<String> procedureSignaturesCypher5 = new ArrayList<String>();
        ArrayList<String> userFunctionSignaturesCypher5 = new ArrayList<String>();
        ArrayList<String> procedureSignaturesCypher25 = new ArrayList<String>();
        ArrayList<String> userFunctionSignaturesCypher25 = new ArrayList<String>();
        ApocProcessor.separateKeysByQueryLanguage(this.procedureSignatures, procedureSignaturesCypher5, procedureSignaturesCypher25);
        ApocProcessor.separateKeysByQueryLanguage(this.userFunctionSignatures, userFunctionSignaturesCypher5, userFunctionSignaturesCypher25);
        if (roundEnv.processingOver()) {
            this.extensionClassWriter.write(procedureSignaturesCypher5, userFunctionSignaturesCypher5, procedureSignaturesCypher25, userFunctionSignaturesCypher25);
        }
        return false;
    }

    private void extractSignature(TypeElement annotation, RoundEnvironment roundEnv) {
        List<Map<String, List<QueryLanguage>>> signatures = this.accumulator(annotation);
        roundEnv.getElementsAnnotatedWith(annotation).forEach(annotatedElement -> signatures.add((Map)this.signatureVisitor.visit((Element)annotatedElement)));
    }

    private List<Map<String, List<QueryLanguage>>> accumulator(TypeElement annotation) {
        if (annotation.getQualifiedName().contentEquals(Procedure.class.getName())) {
            return this.procedureSignatures;
        }
        return this.userFunctionSignatures;
    }

    public static void separateKeysByQueryLanguage(List<Map<String, List<QueryLanguage>>> list, List<String> c5Keys, List<String> c6Keys) {
        for (Map<String, List<QueryLanguage>> map : list) {
            for (Map.Entry<String, List<QueryLanguage>> entry : map.entrySet()) {
                String key = entry.getKey();
                List<QueryLanguage> values = entry.getValue();
                if (values.contains(QueryLanguage.CYPHER_5)) {
                    c5Keys.add(key);
                }
                if (!values.contains(QueryLanguage.CYPHER_25)) continue;
                c6Keys.add(key);
            }
        }
    }
}

