/*
 * Decompiled with CFR 0.152.
 */
package apoc.processor;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleElementVisitor9;
import javax.tools.Diagnostic;
import org.neo4j.kernel.api.QueryLanguage;
import org.neo4j.kernel.api.procedure.QueryLanguageScope;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.UserAggregationFunction;
import org.neo4j.procedure.UserFunction;

public class SignatureVisitor
extends SimpleElementVisitor9<Map<String, List<QueryLanguage>>, Void> {
    private final Elements elementUtils;
    private final Messager messager;

    public SignatureVisitor(Elements elementUtils, Messager messager) {
        this.elementUtils = elementUtils;
        this.messager = messager;
    }

    @Override
    public Map<String, List<QueryLanguage>> visitExecutable(ExecutableElement method, Void unused) {
        return Map.of(this.getAnnotationName(method).orElse(String.format("%s.%s", this.elementUtils.getPackageOf(method), method.getSimpleName())), this.getCypherScopes(method));
    }

    @Override
    public Map<String, List<QueryLanguage>> visitUnknown(Element e, Void unused) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, "unexpected .....");
        return (Map)super.visitUnknown(e, unused);
    }

    private Optional<String> getAnnotationName(ExecutableElement method) {
        return this.getProcedureName(method).or(() -> this.getUserFunctionName(method)).or(() -> this.getUserAggregationFunctionName(method));
    }

    private List<QueryLanguage> getCypherScopes(ExecutableElement method) {
        return Optional.ofNullable(method.getAnnotation(QueryLanguageScope.class)).map(annotation -> {
            QueryLanguage[] scope = annotation.scope();
            return scope.length > 0 ? Arrays.asList(scope) : List.of(QueryLanguage.CYPHER_5, QueryLanguage.CYPHER_25);
        }).orElse(List.of(QueryLanguage.CYPHER_5, QueryLanguage.CYPHER_25));
    }

    private Optional<String> getProcedureName(ExecutableElement method) {
        return Optional.ofNullable(method.getAnnotation(Procedure.class)).map(annotation -> this.pickFirstNonBlank(annotation.name(), annotation.value())).flatMap(this::blankToEmpty);
    }

    private Optional<String> getUserFunctionName(ExecutableElement method) {
        return Optional.ofNullable(method.getAnnotation(UserFunction.class)).map(annotation -> this.pickFirstNonBlank(annotation.name(), annotation.value())).flatMap(this::blankToEmpty);
    }

    private Optional<String> getUserAggregationFunctionName(ExecutableElement method) {
        return Optional.ofNullable(method.getAnnotation(UserAggregationFunction.class)).map(annotation -> this.pickFirstNonBlank(annotation.name(), annotation.value())).flatMap(this::blankToEmpty);
    }

    private Optional<String> blankToEmpty(String s) {
        return s.isBlank() ? Optional.empty() : Optional.of(s);
    }

    private String pickFirstNonBlank(String name, String value) {
        return name.isBlank() ? value : name;
    }
}

