/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.ngrinder.common.constants;

/**
 * Agent related constants.
 *
 * @since 3.3
 */
public interface AgentConstants {
	public static final String PROP_AGENT_ALL_LOGS = "agent.all_logs";
	public static final String PROP_AGENT_KEEP_LOGS = "agent.keep_logs";
	public static final String PROP_AGENT_UPDATE_ALWAYS = "agent.update_always";
	public static final String PROP_AGENT_CONTROLLER_HOST = "agent.controller_host";
	public static final String PROP_AGENT_CONTROLLER_PORT = "agent.controller_port";
	public static final String PROP_AGENT_HOST_ID = "agent.host_id";
	public static final String PROP_AGENT_JAVA_OPT = "agent.java_opt";
	public static final String PROP_AGENT_JVM_CLASSPATH = "agent.jvm.classpath";
	public static final String PROP_AGENT_LIMIT_XMX = "agent.limit_xmx";
	public static final String PROP_AGENT_REGION = "agent.region";
	public static final String PROP_AGENT_SERVER_MODE = "agent.server_mode";
	public static final String PROP_AGENT_CONNECTION_MODE = "agent.connection_mode";
	public static final String PROP_AGENT_CONNECTION_PORT = "agent.connection_port";
	public static final String PROP_AGENT_BROADCAST_IP = "agent.broadcast_ip";
	public static final String PROP_AGENT_ENABLE_LOCAL_DNS = "agent.enable_local_dns";
	public static final String PROP_AGENT_ENABLE_SECURITY = "agent.enable_security";

	public static final String VALUE_AGENT_TO_CONTROLLER = "agent_to_controller";
	public static final String VALUE_CONTROLLER_TO_AGENT = "controller_to_agent";
}
