/*
 * Decompiled with CFR 0.152.
 */
package net.grinder;

import java.net.Socket;
import java.util.Set;
import java.util.function.Predicate;
import net.grinder.AgentControllerServer;
import net.grinder.common.GrinderException;
import net.grinder.common.GrinderProperties;
import net.grinder.common.processidentity.AgentIdentity;
import net.grinder.communication.Address;
import net.grinder.communication.Message;
import net.grinder.console.common.Resources;
import net.grinder.console.common.ResourcesImplementation;
import net.grinder.console.communication.AgentDownloadRequestListener;
import net.grinder.console.communication.AgentProcessControlImplementation;
import net.grinder.console.communication.ConnectionAgentCommunicationListener;
import net.grinder.console.communication.ConnectionAgentListener;
import net.grinder.console.communication.ConsoleCommunication;
import net.grinder.console.communication.ConsoleCommunicationImplementationEx;
import net.grinder.console.communication.LogArrivedListener;
import net.grinder.console.model.ConsoleCommunicationSetting;
import net.grinder.console.model.ConsoleProperties;
import net.grinder.engine.communication.AgentUpdateGrinderMessage;
import net.grinder.message.console.AgentControllerState;
import net.grinder.messages.agent.StartGrinderMessage;
import net.grinder.messages.agent.StopGrinderMessage;
import net.grinder.messages.console.AgentAddress;
import net.grinder.util.ConsolePropertiesFactory;
import net.grinder.util.thread.Condition;
import org.ngrinder.common.util.ExceptionUtils;
import org.ngrinder.monitor.controller.model.SystemDataModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentControllerServerDaemon {
    private final ConsoleProperties consoleProperties;
    private Thread thread;
    private AgentControllerServer agentControllerServer;
    public static final Resources RESOURCES = new ResourcesImplementation("net.grinder.console.common.resources.Console");
    private final Condition m_eventSyncCondition = new Condition();
    public static final Logger LOGGER = LoggerFactory.getLogger((String)RESOURCES.getString("shortTitle"));
    private static final long AGENT_CONTROLLER_SERVER_SHUTDOWN_WAITING_TIMEOUT = 10000L;
    private static final long AGENT_CONTROLLER_SERVER_EVENT_EXPIRATION_TIMEOUT = 10000L;

    public AgentControllerServerDaemon(String ip, int port, ConsoleCommunicationSetting consoleCommunicationSetting) {
        this(ip, port, ConsolePropertiesFactory.createEmptyConsoleProperties(), consoleCommunicationSetting);
    }

    public AgentControllerServerDaemon(String ip, int port, ConsoleProperties consoleProperties, ConsoleCommunicationSetting consoleCommunicationSetting) {
        this.consoleProperties = consoleProperties;
        try {
            this.consoleProperties.setConsoleHost(ip);
            this.consoleProperties.setConsolePort(port);
            this.agentControllerServer = new AgentControllerServer(RESOURCES, LOGGER, consoleProperties, this.m_eventSyncCondition, consoleCommunicationSetting);
        }
        catch (GrinderException e) {
            throw ExceptionUtils.processException("Exception occurred while initiating the agent controller server daemon", e);
        }
    }

    public int getPort() {
        return this.consoleProperties.getConsolePort();
    }

    public AgentControllerServerDaemon(int port) {
        this("", port, ConsoleCommunicationSetting.asDefault());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this.thread = new Thread(this::startSync);
        this.thread.setName("Agent controller server thread");
        this.thread.setDaemon(true);
        this.thread.start();
        Condition condition = this.m_eventSyncCondition;
        synchronized (condition) {
            this.m_eventSyncCondition.waitNoInterrruptException(10000L);
        }
    }

    public void startSync() {
        this.agentControllerServer.run();
    }

    public void shutdown() {
        try {
            this.agentControllerServer.shutdown();
            if (this.thread != null) {
                this.thread.join(10000L);
                this.thread.interrupt();
            }
        }
        catch (Exception e) {
            throw ExceptionUtils.processException("Exception occurred during shutting down the agent controller server daemon", e);
        }
        finally {
            this.thread = null;
        }
    }

    public int getAllAttachedAgentsCount() {
        return this.getComponent(AgentProcessControlImplementation.class).getNumberOfLiveAgents();
    }

    public void addAgentDownloadRequestListener(AgentDownloadRequestListener agentDownloadRequestListener) {
        this.getComponent(AgentProcessControlImplementation.class).addAgentDownloadRequestListener(agentDownloadRequestListener);
    }

    public int getAgentConnectingPort(AgentIdentity agentIdentity) {
        return this.getComponent(AgentProcessControlImplementation.class).getAgentConnectingPort(agentIdentity);
    }

    public String getAgentVersion(AgentIdentity agentIdentity) {
        return this.getComponent(AgentProcessControlImplementation.class).getAgentVersion(agentIdentity);
    }

    public Set<AgentProcessControlImplementation.AgentStatus> getAgentStatusSet(Predicate<AgentProcessControlImplementation.AgentStatus> predicate) {
        return this.getComponent(AgentProcessControlImplementation.class).getAgentStatusSet(predicate);
    }

    public AgentControllerState getAgentState(AgentIdentity agentIdentity) {
        return this.getComponent(AgentProcessControlImplementation.class).getAgentControllerState(agentIdentity);
    }

    public Set<AgentIdentity> getAllFreeAgents() {
        return this.getComponent(AgentProcessControlImplementation.class).getAgents(AgentControllerState.READY, 0);
    }

    public SystemDataModel getSystemDataModel(AgentIdentity agentIdentity) {
        return this.getComponent(AgentProcessControlImplementation.class).getSystemDataModel(agentIdentity);
    }

    public Set<AgentIdentity> getAllAvailableAgents() {
        return this.getComponent(AgentProcessControlImplementation.class).getAllAgents();
    }

    public <T> T getComponent(Class<T> componentType) {
        return this.agentControllerServer.getComponent(componentType);
    }

    public void startAgent(GrinderProperties grinderProperties, AgentIdentity agentIdentity) {
        LOGGER.info("{} agent is started.", (Object)agentIdentity);
        ConsoleCommunicationImplementationEx component = this.getComponent(ConsoleCommunicationImplementationEx.class);
        AgentAddress address = new AgentAddress(agentIdentity);
        String localConnectingAddress = component.getLocalConnectingAddress((Address)address);
        GrinderProperties prop = (GrinderProperties)grinderProperties.clone();
        prop.setProperty("grinder.consoleHost", localConnectingAddress);
        component.sendToAddressedAgents((Address)address, (Message)new StartGrinderMessage(prop, agentIdentity.getNumber()));
    }

    public void stopAgent(AgentIdentity agentIdentity) {
        LOGGER.info("{} agent is stopped.", (Object)agentIdentity);
        this.getComponent(ConsoleCommunication.class).sendToAddressedAgents((Address)new AgentAddress(agentIdentity), (Message)new StopGrinderMessage());
    }

    public void updateAgent(AgentIdentity agentIdentity, String version) {
        this.getComponent(ConsoleCommunication.class).sendToAddressedAgents((Address)new AgentAddress(agentIdentity), (Message)AgentUpdateGrinderMessage.getStartAgentUpdateGrinderMessage(version));
    }

    public void discriminateConnection(Socket socket) {
        this.getComponent(ConsoleCommunicationImplementationEx.class).discriminateConnection(socket);
    }

    public void addAgentStatusUpdateListener(AgentProcessControlImplementation.AgentStatusUpdateListener agentStatusUpdateListener) {
        this.getComponent(AgentProcessControlImplementation.class).addAgentStatusUpdateListener(agentStatusUpdateListener);
    }

    public void addLogArrivedListener(LogArrivedListener logArrivedListener) {
        this.getComponent(AgentProcessControlImplementation.class).addLogArrivedListener(logArrivedListener);
    }

    public void addConnectionAgentListener(ConnectionAgentListener connectionAgentListener) {
        this.getComponent(AgentProcessControlImplementation.class).addConnectionAgentListener(connectionAgentListener);
    }

    public void addConnectionAgentCommunicationListener(ConnectionAgentCommunicationListener listener) {
        this.getComponent(AgentProcessControlImplementation.class).addConnectionAgentCommunicationListener(listener);
    }
}

