/*
 * Decompiled with CFR 0.152.
 */
package net.grinder;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ForkJoinPool;
import java.util.stream.Stream;
import net.grinder.StopReason;
import net.grinder.common.GrinderException;
import net.grinder.common.GrinderProperties;
import net.grinder.common.Test;
import net.grinder.common.processidentity.AgentIdentity;
import net.grinder.common.processidentity.WorkerProcessReport;
import net.grinder.communication.Address;
import net.grinder.console.ConsoleFoundationEx;
import net.grinder.console.common.Resources;
import net.grinder.console.common.ResourcesImplementation;
import net.grinder.console.communication.AcceptDistFilesDigestListener;
import net.grinder.console.communication.ConsoleCommunicationImplementationEx;
import net.grinder.console.communication.ProcessControl;
import net.grinder.console.distribution.AgentCacheState;
import net.grinder.console.distribution.FileDistribution;
import net.grinder.console.distribution.FileDistributionHandler;
import net.grinder.console.model.ConsoleCommunicationSetting;
import net.grinder.console.model.ConsoleProperties;
import net.grinder.console.model.ModelTestIndex;
import net.grinder.console.model.SampleListener;
import net.grinder.console.model.SampleModel;
import net.grinder.console.model.SampleModelImplementationEx;
import net.grinder.console.model.SampleModelViews;
import net.grinder.messages.agent.RefreshCacheMessage;
import net.grinder.messages.console.AgentAddress;
import net.grinder.statistics.ExpressionView;
import net.grinder.statistics.StatisticExpression;
import net.grinder.statistics.StatisticsIndexMap;
import net.grinder.statistics.StatisticsServicesImplementation;
import net.grinder.statistics.StatisticsSet;
import net.grinder.util.AllocateLowestNumber;
import net.grinder.util.ConsolePropertiesFactory;
import net.grinder.util.Directory;
import net.grinder.util.FileContents;
import net.grinder.util.ListenerHelper;
import net.grinder.util.ListenerSupport;
import net.grinder.util.thread.Condition;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.mutable.MutableBoolean;
import org.ngrinder.common.util.CollectionUtils;
import org.ngrinder.common.util.DateUtils;
import org.ngrinder.common.util.ExceptionUtils;
import org.ngrinder.common.util.Preconditions;
import org.ngrinder.common.util.ReflectionUtils;
import org.ngrinder.common.util.ThreadUtils;
import org.ngrinder.service.AbstractSingleConsole;
import org.python.google.common.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleConsole
extends AbstractSingleConsole
implements ProcessControl.Listener,
SampleListener,
AcceptDistFilesDigestListener {
    private static final String RESOURCE_CONSOLE = "net.grinder.console.common.resources.Console";
    private Thread consoleFoundationThread;
    private ConsoleFoundationEx consoleFoundation;
    public static final Resources RESOURCE = new ResourcesImplementation("net.grinder.console.common.resources.Console");
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"console");
    public static final String REPORT_DATA = ".data";
    private static final String REPORT_CSV = "output.csv";
    private static final int NUM_OF_SEND_FILE_DIGEST_THREAD = 3;
    private final Condition eventSyncCondition = new Condition();
    private ProcessControl.ProcessReports[] processReports;
    private CopyOnWriteArrayList<Set<String>> agentCachedDistFilesDigestList = new CopyOnWriteArrayList();
    private boolean cancel = false;
    private double tpsValue = 0.0;
    private double peakTpsForGraph = 0.0;
    private SampleModel sampleModel;
    private SampleModelViews modelView;
    private long startTime = 0L;
    private long momentWhenTpsBeganToHaveVerySmall;
    private final ListenerSupport<ConsoleShutdownListener> shutdownListener = ListenerHelper.create();
    private final ListenerSupport<SamplingLifeCycleListener> samplingLifeCycleListener = ListenerHelper.create();
    private final ListenerSupport<SamplingLifeCycleFollowUpListener> samplingLifeCycleFollowupListener = ListenerHelper.create();
    public static final int MIN_SAMPLING_INTERVAL_TO_ACTIVATE_TPS_PER_TEST = 3000;
    private boolean capture = false;
    private File reportPath;
    private Map<String, Object> statisticData;
    private boolean headerAdded = false;
    private GrinderProperties properties;
    private Map<String, BufferedWriter> fileWriterMap = CollectionUtils.newHashMap();
    private long samplingCount = 0L;
    private int runningThread = 0;
    private int runningProcess = 0;
    private int currentNotFinishedProcessCount = 0;
    private static final int TOO_LOW_TPS_TIME = 60000;
    private static final int TOO_MANY_ERROR_TIME = 10000;
    private Map<Test, StatisticsSet> intervalStatisticMapPerTest = Collections.synchronizedMap(new LinkedHashMap());
    private Map<Test, StatisticsSet> accumulatedStatisticMapPerTest = Collections.synchronizedMap(new LinkedHashMap());
    private String cvsSeparator = ",";
    private ExpressionView[] expressionViews = null;
    private Set<Map.Entry<String, StatisticExpression>> statisticExpressionMap;
    private long lastSamplingPeriod = 0L;
    private static final Set<String> INTERESTING_PER_TEST_STATISTICS = Sets.newHashSet((Object[])new String[]{"Errors", "TPS", "Mean_time_to_first_byte", "Mean_Test_Time_(ms)"});
    private static final Set<String> INTERESTING_STATISTICS = Sets.newHashSet((Object[])new String[]{"Tests", "Errors", "TPS", "Response_bytes_per_second", "Mean_time_to_first_byte", "Peak_TPS", "Mean_Test_Time_(ms)"});

    public SingleConsole(int port) {
        this("", port, ConsoleCommunicationSetting.asDefault(), ConsolePropertiesFactory.createEmptyConsoleProperties());
    }

    public SingleConsole(String ip, int port, ConsoleCommunicationSetting consoleCommunicationSetting, ConsoleProperties consoleProperties) {
        this.init(ip, port, consoleCommunicationSetting, consoleProperties);
    }

    protected void init(String ip, int port, ConsoleCommunicationSetting consoleCommunicationSetting, ConsoleProperties consoleProperties) {
        try {
            if (StringUtils.isNotEmpty((String)ip)) {
                consoleProperties.setConsoleHost(ip);
            }
            consoleProperties.setConsolePort(port);
            this.consoleFoundation = new ConsoleFoundationEx(RESOURCE, LOGGER, consoleProperties, consoleCommunicationSetting, this.eventSyncCondition);
            this.consoleFoundation.addDistFilesDigestAcceptListener(this);
            this.modelView = this.getConsoleComponent(SampleModelViews.class);
            this.getConsoleComponent(ProcessControl.class).addProcessStatusListener((ProcessControl.Listener)this);
        }
        catch (GrinderException e) {
            throw ExceptionUtils.processException("Exception occurred while creating SingleConsole", e);
        }
    }

    @Override
    public int getConsolePort() {
        return this.getConsoleProperties().getConsolePort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (this.getConsoleFoundation() == null) {
            return;
        }
        Condition condition = this.eventSyncCondition;
        synchronized (condition) {
            this.consoleFoundationThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    SingleConsole.this.getConsoleFoundation().run();
                }
            }, "console on port " + this.getConsolePort());
            this.consoleFoundationThread.setDaemon(true);
            this.consoleFoundationThread.start();
            this.eventSyncCondition.waitNoInterrruptException(5000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        try {
            SingleConsole singleConsole = this;
            synchronized (singleConsole) {
                this.getConsoleFoundation().shutdown();
                if (this.consoleFoundationThread != null && !this.consoleFoundationThread.isInterrupted()) {
                    this.consoleFoundationThread.interrupt();
                    this.consoleFoundationThread.join(1000L);
                }
                this.samplingCount = 0L;
            }
        }
        catch (Exception e) {
            try {
                throw ExceptionUtils.processException("Exception occurred while shutting down console", e);
            }
            catch (Throwable throwable) {
                for (BufferedWriter bw : this.fileWriterMap.values()) {
                    IOUtils.closeQuietly((Writer)bw);
                }
                this.fileWriterMap.clear();
                throw throwable;
            }
        }
        for (BufferedWriter bw : this.fileWriterMap.values()) {
            IOUtils.closeQuietly((Writer)bw);
        }
        this.fileWriterMap.clear();
    }

    public int getAllAttachedAgentsCount() {
        return this.getConsoleFoundation().getComponent(ProcessControl.class).getNumberOfLiveAgents();
    }

    protected ConsoleFoundationEx getConsoleFoundation() {
        return Preconditions.checkNotNull(this.consoleFoundation);
    }

    @Override
    public List<AgentIdentity> getAllAttachedAgents() {
        final List<AgentIdentity> agentIdentities = CollectionUtils.newArrayList();
        AllocateLowestNumber agentIdentity = (AllocateLowestNumber)Preconditions.checkNotNull(ReflectionUtils.getFieldValue(this.getConsoleFoundation().getComponent(ProcessControl.class), "m_agentNumberMap"), "m_agentNumberMap on ProcessControlImplementation is not available in this grinder version");
        agentIdentity.forEach(new AllocateLowestNumber.IteratorCallback(){

            public void objectAndNumber(Object object, int number) {
                agentIdentities.add((AgentIdentity)object);
            }
        });
        return agentIdentities;
    }

    public <T> T getConsoleComponent(Class<T> componentType) {
        return this.getConsoleFoundation().getComponent(componentType);
    }

    public ConsoleProperties getConsoleProperties() {
        return this.getConsoleComponent(ConsoleProperties.class);
    }

    public long startTest(GrinderProperties properties) {
        properties.setInt("grinder.consolePort", this.getConsolePort());
        this.getConsoleComponent(ProcessControl.class).startWorkerProcesses(properties);
        this.properties = properties;
        this.startTime = System.currentTimeMillis();
        return this.startTime;
    }

    public void setDistributionDirectory(File filePath) {
        ConsoleProperties properties = this.getConsoleComponent(ConsoleProperties.class);
        try {
            Directory directory = new Directory(filePath);
            properties.setAndSaveDistributionDirectory(directory);
        }
        catch (Exception e) {
            LOGGER.error("Error occurred during setting distribution directory to {} : {}", (Object)filePath, (Object)e.getMessage());
            throw ExceptionUtils.processException(e.getMessage(), e);
        }
    }

    @Override
    public void cancel() {
        this.cancel = true;
    }

    private boolean shouldEnable(FileDistribution fileDistribution) {
        return fileDistribution.getAgentCacheState().getOutOfDate();
    }

    public void distributeFiles(File filePath, ListenerSupport<FileDistributionListener> listener, boolean safe) {
        this.setDistributionDirectory(filePath);
        this.distributeFiles(listener, safe);
    }

    public String getConsoleIP() {
        return this.getConsoleProperties().getConsoleHost();
    }

    @Override
    public void onAcceptDistFilesDigestListener(Set<String> distFilesDigest) {
        this.agentCachedDistFilesDigestList.add(distFilesDigest);
    }

    public void sendDistFilesDigestToAgents(Set<String> distFilesDigest) {
        ForkJoinPool myPool = new ForkJoinPool(3);
        myPool.submit(() -> ((Stream)Arrays.stream(this.processReports).parallel()).forEach(processReport -> this.getConsoleComponent(ConsoleCommunicationImplementationEx.class).sendToAddressedAgents((Address)new AgentAddress(processReport.getAgentProcessReport().getAgentIdentity()), new RefreshCacheMessage(distFilesDigest))));
        LOGGER.info("Send digest of distribution files to agent for refresh agent's cache directory.");
    }

    public void distributeFiles(ListenerSupport<FileDistributionListener> listener, final boolean safe) {
        FileDistribution fileDistribution = this.getConsoleComponent(FileDistribution.class);
        AgentCacheState agentCacheState = fileDistribution.getAgentCacheState();
        final Condition cacheStateCondition = new Condition();
        agentCacheState.addListener(new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChange(PropertyChangeEvent ignored) {
                Condition condition = cacheStateCondition;
                synchronized (condition) {
                    cacheStateCondition.notifyAll();
                }
            }
        });
        final MutableBoolean safeDist = new MutableBoolean(safe);
        ConsoleProperties consoleComponent = this.getConsoleComponent(ConsoleProperties.class);
        final File file = consoleComponent.getDistributionDirectory().getFile();
        if (listener != null) {
            listener.apply((ListenerSupport.Informer)new ListenerSupport.Informer<FileDistributionListener>(){

                public void inform(FileDistributionListener listener) {
                    safeDist.setValue(listener.start(file, safe));
                }
            });
        }
        FileDistributionHandler distributionHandler = fileDistribution.getHandler();
        int fileCount = 0;
        while (!this.cancel) {
            try {
                final FileDistributionHandler.Result result = distributionHandler.sendNextFile();
                ++fileCount;
                if (result == null) break;
                if (listener != null) {
                    listener.apply((ListenerSupport.Informer)new ListenerSupport.Informer<FileDistributionListener>(){

                        public void inform(FileDistributionListener listener) {
                            listener.distributed(result.getFileName());
                        }
                    });
                }
                if (!safeDist.isTrue()) continue;
                this.checkSafetyWithCacheState(fileDistribution, cacheStateCondition, 1);
            }
            catch (FileContents.FileContentsException e) {
                throw ExceptionUtils.processException("Error while distribute files for " + this.getConsolePort());
            }
        }
        if (safeDist.isFalse()) {
            ThreadUtils.sleep(1000L);
            this.checkSafetyWithCacheState(fileDistribution, cacheStateCondition, fileCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkSafetyWithCacheState(FileDistribution fileDistribution, Condition cacheStateCondition, int fileCount) {
        Condition condition = cacheStateCondition;
        synchronized (condition) {
            for (int i = 0; i < 10 * fileCount && this.shouldEnable(fileDistribution); ++i) {
                cacheStateCondition.waitNoInterrruptException(500L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilAgentPrepared(int size) {
        int trial = 1;
        while (trial++ < 10) {
            if (this.processReports == null || this.processReports.length != size || this.agentCachedDistFilesDigestList.size() != size) {
                Condition condition = this.eventSyncCondition;
                synchronized (condition) {
                    this.eventSyncCondition.waitNoInterrruptException(1000L);
                    continue;
                }
            }
            if (this.isCanceled()) {
                return;
            }
            return;
        }
        throw ExceptionUtils.processException("Connection is not completed or cached files digest weren't received until 10 sec");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilAllAgentDisconnected() {
        int trial = 1;
        while (trial++ < 40) {
            if (this.runningThread != 0) {
                Condition condition = this.eventSyncCondition;
                synchronized (condition) {
                    this.eventSyncCondition.waitNoInterrruptException(500L);
                }
                if (trial % 10 != 0) continue;
                this.sendStopMessageToAgents();
                continue;
            }
            return;
        }
        throw ExceptionUtils.processException("Connection is not completed for 20 sec");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAllTestFinished() {
        SingleConsole singleConsole = this;
        synchronized (singleConsole) {
            if (this.runningThread == 0) {
                return true;
            }
            return this.currentNotFinishedProcessCount == 0;
            {
            }
        }
    }

    public void setTpsValue(double newValue) {
        this.peakTpsForGraph = Math.max(this.peakTpsForGraph, newValue);
        this.tpsValue = newValue;
    }

    public double getTpsValues() {
        return this.tpsValue;
    }

    @Override
    public long getCurrentRunningTime() {
        return System.currentTimeMillis() - this.startTime;
    }

    @Override
    public StatisticsIndexMap getStatisticsIndexMap() {
        return StatisticsServicesImplementation.getInstance().getStatisticsIndexMap();
    }

    public ExpressionView[] getExpressionView() {
        if (this.expressionViews == null) {
            this.expressionViews = this.modelView.getCumulativeStatisticsView().getExpressionViews();
        }
        return this.expressionViews;
    }

    public Set<Map.Entry<String, StatisticExpression>> getExpressionEntrySet() {
        if (this.statisticExpressionMap == null) {
            Map<String, StatisticExpression> expressionMap = CollectionUtils.newLinkedHashMap();
            for (ExpressionView each : this.getExpressionView()) {
                expressionMap.put(each.getDisplayName().replaceAll("\\s+", "_"), each.getExpression());
            }
            this.statisticExpressionMap = expressionMap.entrySet();
        }
        return this.statisticExpressionMap;
    }

    public void update(final StatisticsSet intervalStatistics, final StatisticsSet cumulativeStatistics) {
        try {
            if (!this.capture) {
                return;
            }
            ++this.samplingCount;
            long currentPeriod = cumulativeStatistics.getValue(this.getSampleModel().getPeriodIndex());
            this.setTpsValue(this.sampleModel.getTPSExpression().getDoubleValue(intervalStatistics));
            this.checkTooLowTps(this.getTpsValues());
            this.updateStatistics(intervalStatistics, cumulativeStatistics);
            this.writeIntervalCsvData(intervalStatistics);
            int interval = this.getSampleModel().getSampleInterval();
            long gap = 1L;
            if (this.samplingCount == 1L) {
                this.lastSamplingPeriod = currentPeriod;
            } else {
                this.lastSamplingPeriod += (long)interval;
                gap = (currentPeriod - this.lastSamplingPeriod) / (long)interval;
            }
            this.samplingLifeCycleListener.apply((ListenerSupport.Informer)new ListenerSupport.Informer<SamplingLifeCycleListener>(){

                public void inform(SamplingLifeCycleListener listener) {
                    listener.onSampling(SingleConsole.this.getReportPath(), intervalStatistics, cumulativeStatistics);
                }
            });
            long repeatCounts = gap + 1L;
            for (long index = 0L; index < repeatCounts; ++index) {
                final boolean lastCall = this.samplingCount == 1L && index == 0L || this.samplingCount != 1L && index == gap;
                this.writeIntervalSummaryData(intervalStatistics, lastCall);
                if (interval >= 3000) {
                    this.writeIntervalSummaryDataPerTest(this.intervalStatisticMapPerTest, lastCall);
                }
                this.samplingLifeCycleFollowupListener.apply((ListenerSupport.Informer)new ListenerSupport.Informer<SamplingLifeCycleFollowUpListener>(){

                    public void inform(SamplingLifeCycleFollowUpListener listener) {
                        listener.onSampling(SingleConsole.this.getReportPath(), intervalStatistics, cumulativeStatistics, lastCall);
                    }
                });
            }
            this.lastSamplingPeriod += (long)interval * gap;
        }
        catch (RuntimeException e) {
            LOGGER.error("Error occurred while updating the statistics : {}", (Object)e.getMessage());
            LOGGER.debug("Details : ", (Throwable)e);
            throw e;
        }
    }

    private void writeIntervalSummaryDataPerTest(Map<Test, StatisticsSet> intervalStatisticMapPerTest, boolean lastCall) {
        if (intervalStatisticMapPerTest.size() > 1) {
            for (Map.Entry<String, StatisticExpression> each : this.getExpressionEntrySet()) {
                if (!SingleConsole.isPerfTestInterestingStatistics(each.getKey())) continue;
                for (Map.Entry<Test, StatisticsSet> entry : intervalStatisticMapPerTest.entrySet()) {
                    if (lastCall) {
                        StatisticsSet value = entry.getValue();
                        this.writeReportData(each.getKey() + "-" + entry.getKey().getNumber() + "_" + entry.getKey().getDescription().replaceAll("\\s+", "_") + REPORT_DATA, this.formatValue(SingleConsole.getRealDoubleValue(each.getValue().getDoubleValue(value))));
                        continue;
                    }
                    this.writeReportData(each.getKey() + "-" + entry.getKey().getNumber() + "_" + entry.getKey().getDescription().replaceAll("\\s+", "_") + REPORT_DATA, "null");
                }
            }
        }
    }

    public void writeIntervalSummaryData(StatisticsSet intervalStatistics, boolean firstCall) {
        for (Map.Entry<String, StatisticExpression> each : this.getExpressionEntrySet()) {
            if (firstCall) {
                double doubleValue = each.getValue().getDoubleValue(intervalStatistics);
                this.writeReportData(each.getKey() + REPORT_DATA, this.formatValue(SingleConsole.getRealDoubleValue(doubleValue)));
                continue;
            }
            this.writeReportData(each.getKey() + REPORT_DATA, "null");
        }
        this.writeReportData("Vuser.data", this.formatValue(this.runningThread));
    }

    public void writeIntervalCsvData(StatisticsSet intervalStatistics) {
        if (!this.headerAdded) {
            StringBuilder csvHeader = new StringBuilder();
            csvHeader.append("DateTime").append(this.cvsSeparator).append("vuser");
            for (Map.Entry<String, StatisticExpression> entry : this.getExpressionEntrySet()) {
                if (entry.getKey().equals("Peak_TPS")) continue;
                csvHeader.append(this.cvsSeparator).append(entry.getKey());
            }
            if (this.intervalStatisticMapPerTest.size() != 1) {
                for (int i = 1; i <= this.intervalStatisticMapPerTest.size(); ++i) {
                    csvHeader.append(this.cvsSeparator).append("Description");
                    for (Map.Entry<String, StatisticExpression> entry : this.getExpressionEntrySet()) {
                        if (entry.getKey().equals("Peak_TPS")) continue;
                        csvHeader.append(this.cvsSeparator).append(entry.getKey()).append("-").append(i);
                    }
                }
            }
            this.writeCSVDataLine(csvHeader.toString());
            this.headerAdded = true;
        }
        StringBuilder csvLine = new StringBuilder();
        csvLine.append(DateUtils.dateToString(new Date())).append(this.cvsSeparator).append(this.runningThread);
        for (Map.Entry<String, StatisticExpression> entry : this.getExpressionEntrySet()) {
            if (entry.getKey().equals("Peak_TPS")) continue;
            double d = entry.getValue().getDoubleValue(intervalStatistics);
            csvLine.append(this.cvsSeparator).append(this.formatValue(SingleConsole.getRealDoubleValue(d)));
        }
        if (this.intervalStatisticMapPerTest.size() != 1) {
            for (Map.Entry<String, StatisticExpression> entry : this.intervalStatisticMapPerTest.entrySet()) {
                String string = ((Test)entry.getKey()).getDescription();
                csvLine.append(this.cvsSeparator).append(string);
                for (Map.Entry<String, StatisticExpression> each : this.getExpressionEntrySet()) {
                    if (each.getKey().equals("Peak_TPS")) continue;
                    csvLine.append(this.cvsSeparator).append(this.formatValue(SingleConsole.getRealDoubleValue(each.getValue().getDoubleValue((StatisticsSet)entry.getValue()))));
                }
            }
        }
        this.writeCSVDataLine(csvLine.toString());
    }

    private void checkTooLowTps(double tps) {
        if (tps < 0.001) {
            if (this.momentWhenTpsBeganToHaveVerySmall == 0L) {
                this.momentWhenTpsBeganToHaveVerySmall = System.currentTimeMillis();
            } else if (new Date().getTime() - this.momentWhenTpsBeganToHaveVerySmall >= 60000L) {
                LOGGER.warn("Stop the test because its tps is less than 0.001 for more than {} minitue.", (Object)1);
                this.getListeners().apply((ListenerSupport.Informer)new ListenerSupport.Informer<ConsoleShutdownListener>(){

                    public void inform(ConsoleShutdownListener listener) {
                        listener.readyToStop(StopReason.TOO_LOW_TPS);
                    }
                });
                this.momentWhenTpsBeganToHaveVerySmall = 0L;
            }
        } else {
            this.momentWhenTpsBeganToHaveVerySmall = 0L;
        }
    }

    public static boolean isPerfTestInterestingStatistics(String key) {
        return INTERESTING_PER_TEST_STATISTICS.contains(key) || key.startsWith("User_defined");
    }

    public static boolean isInterestingStatistics(String key) {
        return INTERESTING_STATISTICS.contains(key) || key.startsWith("User_defined");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateStatistics(StatisticsSet intervalStatistics, StatisticsSet accumulatedStatistics) {
        Map<String, Object> result = CollectionUtils.newHashMap();
        result.put("testTime", this.getCurrentRunningTime() / 1000L);
        ArrayList<Map<String, Object>> cumulativeStatistics = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> lastSampleStatistics = new ArrayList<Map<String, Object>>();
        for (Test test : this.accumulatedStatisticMapPerTest.keySet()) {
            Map<String, Object> accumulatedStatisticMap = CollectionUtils.newHashMap();
            Map<String, Object> intervalStatisticsMap = CollectionUtils.newHashMap();
            StatisticsSet accumulatedSet = this.accumulatedStatisticMapPerTest.get(test);
            StatisticsSet intervalSet = this.intervalStatisticMapPerTest.get(test);
            accumulatedStatisticMap.put("testNumber", test.getNumber());
            accumulatedStatisticMap.put("testDescription", test.getDescription());
            intervalStatisticsMap.put("testNumber", test.getNumber());
            intervalStatisticsMap.put("testDescription", test.getDescription());
            for (Map.Entry<String, StatisticExpression> each : this.getExpressionEntrySet()) {
                if (!SingleConsole.isInterestingStatistics(each.getKey())) continue;
                accumulatedStatisticMap.put(each.getKey(), SingleConsole.getRealDoubleValue(each.getValue().getDoubleValue(accumulatedSet)));
                intervalStatisticsMap.put(each.getKey(), SingleConsole.getRealDoubleValue(each.getValue().getDoubleValue(intervalSet)));
            }
            cumulativeStatistics.add(accumulatedStatisticMap);
            lastSampleStatistics.add(intervalStatisticsMap);
        }
        Map<String, Object> totalStatistics = CollectionUtils.newHashMap();
        for (Map.Entry<String, StatisticExpression> each : this.getExpressionEntrySet()) {
            if (!SingleConsole.isInterestingStatistics(each.getKey())) continue;
            totalStatistics.put(each.getKey(), SingleConsole.getRealDoubleValue(each.getValue().getDoubleValue(accumulatedStatistics)));
        }
        result.put("totalStatistics", totalStatistics);
        result.put("cumulativeStatistics", cumulativeStatistics);
        result.put("lastSampleStatistics", lastSampleStatistics);
        result.put("tpsChartData", this.getTpsValues());
        result.put("peakTpsForGraph", this.peakTpsForGraph);
        SingleConsole singleConsole = this;
        synchronized (singleConsole) {
            result.put("process", this.runningProcess);
            result.put("thread", this.runningThread);
            result.put("success", !this.isAllTestFinished());
        }
        this.statisticData = result;
    }

    @Override
    public long getCurrentExecutionCount() {
        Map totalStatistics = (Map)this.getStatisticsData().get("totalStatistics");
        Double testCount = MapUtils.getDoubleValue((Map)totalStatistics, (Object)"Tests", (double)0.0);
        Double errorCount = MapUtils.getDoubleValue((Map)totalStatistics, (Object)"Errors", (double)0.0);
        return testCount.longValue() + errorCount.longValue();
    }

    private static Object getRealDoubleValue(Double doubleValue) {
        if (doubleValue == null) {
            return 0.0;
        }
        return doubleValue.isInfinite() || doubleValue.isNaN() ? 0.0 : doubleValue;
    }

    public ListenerSupport<ConsoleShutdownListener> getListeners() {
        return this.shutdownListener;
    }

    public void addListener(ConsoleShutdownListener listener) {
        this.shutdownListener.add((Object)listener);
    }

    public void addSamplingLifeCycleListener(SamplingLifeCycleListener listener) {
        this.samplingLifeCycleListener.add((Object)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(ProcessControl.ProcessReports[] processReports) {
        Condition condition = this.eventSyncCondition;
        synchronized (condition) {
            this.checkExecutionErrors(processReports);
            this.processReports = processReports;
            this.updateCurrentProcessAndThread(processReports);
            this.eventSyncCondition.notifyAll();
        }
    }

    private void checkExecutionErrors(ProcessControl.ProcessReports[] processReports) {
        if (this.samplingCount == 0L && ArrayUtils.isNotEmpty((Object[])this.processReports) && ArrayUtils.isEmpty((Object[])processReports)) {
            this.getListeners().apply((ListenerSupport.Informer)new ListenerSupport.Informer<ConsoleShutdownListener>(){

                public void inform(ConsoleShutdownListener listener) {
                    listener.readyToStop(StopReason.SCRIPT_ERROR);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCurrentProcessAndThread(ProcessControl.ProcessReports[] processReports) {
        int notFinishedWorkerCount = 0;
        int processCount = 0;
        int threadCount = 0;
        for (ProcessControl.ProcessReports agentReport : processReports) {
            for (WorkerProcessReport processReport : agentReport.getWorkerProcessReports()) {
                if (processReport.getState() != 3) {
                    ++notFinishedWorkerCount;
                }
                ++processCount;
                threadCount += processReport.getNumberOfRunningThreads();
            }
        }
        SingleConsole singleConsole = this;
        synchronized (singleConsole) {
            this.runningProcess = processCount;
            this.runningThread = threadCount;
            this.currentNotFinishedProcessCount = notFinishedWorkerCount;
        }
    }

    private void writeReportData(String name, String value) {
        try {
            BufferedWriter bw = this.fileWriterMap.get(name);
            if (bw == null) {
                bw = new BufferedWriter(new FileWriter(new File(this.reportPath, name), true));
                this.fileWriterMap.put(name, bw);
            }
            bw.write(value);
            bw.newLine();
            bw.flush();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw ExceptionUtils.processException(e);
        }
    }

    private void writeCSVDataLine(String line) {
        this.writeReportData(REPORT_CSV, line);
    }

    private String formatValue(Object val) {
        if (val instanceof Double) {
            DecimalFormat formatter = new DecimalFormat("###.###");
            formatter.setGroupingUsed(false);
            return formatter.format(val);
        }
        if (String.valueOf(val).equals("null")) {
            return "0";
        }
        return String.valueOf(val);
    }

    public Map<String, Object> getStatisticsData() {
        return this.statisticData != null ? this.statisticData : this.getNullStatisticsData();
    }

    protected Map<String, Object> getNullStatisticsData() {
        HashMap<String, Object> result = new HashMap<String, Object>(1);
        result.put("test_time", this.getCurrentRunningTime() / 1000L);
        return result;
    }

    @Override
    public File getReportPath() {
        return this.reportPath;
    }

    public void setReportPath(File reportPath) {
        if (Preconditions.checkNotNull(reportPath, "the report folder should not be empty!").mkdirs()) {
            LOGGER.debug("the report folder is created");
        }
        this.reportPath = reportPath;
    }

    public void sendStopMessageToAgents() {
        this.getConsoleComponent(ProcessControl.class).stopAgentAndWorkerProcesses();
    }

    public void startSampling() {
        this.sampleModel = this.getConsoleComponent(SampleModelImplementationEx.class);
        this.sampleModel.addTotalSampleListener((SampleListener)this);
        this.sampleModel.addModelListener(new SampleModel.Listener(){

            public void stateChanged() {
                SingleConsole.this.capture = SingleConsole.this.sampleModel.getState().isCapturing();
            }

            public void resetTests() {
                SingleConsole.this.intervalStatisticMapPerTest.clear();
                SingleConsole.this.accumulatedStatisticMapPerTest.clear();
            }

            public void newTests(Set<Test> newTests, ModelTestIndex modelTestIndex) {
                for (final Test each : newTests) {
                    SingleConsole.this.sampleModel.addSampleListener(each, new SampleListener(){

                        public void update(StatisticsSet intervalStatistics, StatisticsSet cumulativeStatistics) {
                            SingleConsole.this.intervalStatisticMapPerTest.put(each, intervalStatistics.snapshot());
                            SingleConsole.this.accumulatedStatisticMapPerTest.put(each, cumulativeStatistics.snapshot());
                        }
                    });
                }
            }

            public void newSample() {
            }
        });
        this.informTestSamplingStart();
        this.sampleModel.start();
        LOGGER.info("Sampling is started");
    }

    public void unregisterSampling() {
        this.currentNotFinishedProcessCount = 0;
        if (this.sampleModel != null) {
            this.sampleModel.reset();
            this.sampleModel.stop();
        }
        LOGGER.info("Sampling is stopped");
        this.informTestSamplingEnd();
    }

    private void informTestSamplingStart() {
        this.samplingLifeCycleListener.apply((ListenerSupport.Informer)new ListenerSupport.Informer<SamplingLifeCycleListener>(){

            public void inform(SamplingLifeCycleListener listener) {
                try {
                    listener.onSamplingStarted();
                }
                catch (Exception e) {
                    LOGGER.error("Error occurred while running sampling start listener", (Throwable)e);
                }
            }
        });
        this.samplingLifeCycleFollowupListener.apply((ListenerSupport.Informer)new ListenerSupport.Informer<SamplingLifeCycleFollowUpListener>(){

            public void inform(SamplingLifeCycleFollowUpListener listener) {
                try {
                    listener.onSamplingStarted();
                }
                catch (Exception e) {
                    LOGGER.error("Error occurred while running sampling start listener", (Throwable)e);
                }
            }
        });
    }

    private void informTestSamplingEnd() {
        this.samplingLifeCycleListener.apply((ListenerSupport.Informer)new ListenerSupport.Informer<SamplingLifeCycleListener>(){

            public void inform(SamplingLifeCycleListener listener) {
                try {
                    listener.onSamplingEnded();
                }
                catch (Exception e) {
                    LOGGER.error("Error occurred while running sampling end listener", (Throwable)e);
                }
            }
        });
        this.samplingLifeCycleFollowupListener.apply((ListenerSupport.Informer)new ListenerSupport.Informer<SamplingLifeCycleFollowUpListener>(){

            public void inform(SamplingLifeCycleFollowUpListener listener) {
                try {
                    listener.onSamplingEnded();
                }
                catch (Exception e) {
                    LOGGER.error("Error occurred while running sampling end listener", (Throwable)e);
                }
            }
        });
    }

    @Override
    public GrinderProperties getGrinderProperties() {
        return this.properties;
    }

    public boolean hasTooManyError() {
        long currentTestsCount = this.getCurrentExecutionCount();
        double errors = MapUtils.getDoubleValue((Map)((Map)this.getStatisticsData().get("totalStatistics")), (Object)"Errors", (double)0.0);
        return currentTestsCount != 0L && errors / (double)currentTestsCount > 0.2;
    }

    public boolean hasNoPerformedTest() {
        return this.getCurrentExecutionCount() == 0L;
    }

    public boolean isCanceled() {
        return this.cancel;
    }

    public boolean isCurrentRunningTimeOverDuration(long duration) {
        return this.getCurrentRunningTime() > duration;
    }

    @Override
    public double getPeakTpsForGraph() {
        return this.peakTpsForGraph;
    }

    public SampleModelImplementationEx getSampleModel() {
        return (SampleModelImplementationEx)this.sampleModel;
    }

    public void setSampleModel(SampleModel sampleModel) {
        this.sampleModel = sampleModel;
    }

    @Override
    public int getRunningThread() {
        return this.runningThread;
    }

    @Override
    public int getRunningProcess() {
        return this.runningProcess;
    }

    public List<Set<String>> getAgentCachedDistFilesDigestList() {
        return this.agentCachedDistFilesDigestList;
    }

    public void addSamplingLifeCycleFollowUpCycleListener(SamplingLifeCycleFollowUpListener listener) {
        this.samplingLifeCycleFollowupListener.add((Object)listener);
    }

    public void setCsvSeparator(String csvSeparator) {
        this.cvsSeparator = csvSeparator;
    }

    public static interface ConsoleShutdownListener {
        public void readyToStop(StopReason var1);
    }

    public static interface SamplingLifeCycleFollowUpListener {
        public void onSamplingStarted();

        public void onSampling(File var1, StatisticsSet var2, StatisticsSet var3, boolean var4);

        public void onSamplingEnded();
    }

    public static interface SamplingLifeCycleListener {
        public void onSamplingStarted();

        public void onSampling(File var1, StatisticsSet var2, StatisticsSet var3);

        public void onSamplingEnded();
    }

    public static abstract class FileDistributionListener {
        public abstract boolean start(File var1, boolean var2);

        public abstract void distributed(String var1);
    }
}

