/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.console.communication;

import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import net.grinder.common.GrinderProperties;
import net.grinder.common.processidentity.AgentIdentity;
import net.grinder.common.processidentity.ProcessIdentity;
import net.grinder.communication.Address;
import net.grinder.communication.CommunicationException;
import net.grinder.communication.Message;
import net.grinder.communication.MessageDispatchRegistry;
import net.grinder.console.communication.AgentDownloadRequestListener;
import net.grinder.console.communication.AgentProcessControl;
import net.grinder.console.communication.ConnectionAgentCommunicationListener;
import net.grinder.console.communication.ConnectionAgentListener;
import net.grinder.console.communication.ConsoleCommunication;
import net.grinder.console.communication.LogArrivedListener;
import net.grinder.engine.communication.AgentDownloadGrinderMessage;
import net.grinder.engine.communication.AgentUpdateGrinderMessage;
import net.grinder.engine.communication.ConnectionAgentCommunicationMessage;
import net.grinder.engine.communication.ConnectionAgentMessage;
import net.grinder.engine.communication.LogReportGrinderMessage;
import net.grinder.message.console.AgentControllerProcessReportMessage;
import net.grinder.message.console.AgentControllerState;
import net.grinder.messages.agent.StartGrinderMessage;
import net.grinder.messages.agent.StopGrinderMessage;
import net.grinder.messages.console.AgentAddress;
import net.grinder.util.ListenerSupport;
import org.ngrinder.common.util.CollectionUtils;
import org.ngrinder.monitor.controller.model.SystemDataModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentProcessControlImplementation
implements AgentProcessControl {
    private final ConsoleCommunication m_consoleCommunication;
    private Map<AgentIdentity, AgentStatus> m_agentMap = new ConcurrentHashMap<AgentIdentity, AgentStatus>();
    private final ListenerSupport<AgentStatusUpdateListener> m_agentStatusUpdateListeners = new ListenerSupport();
    private final ListenerSupport<LogArrivedListener> m_logListeners = new ListenerSupport();
    private final ListenerSupport<AgentDownloadRequestListener> m_agentDownloadRequestListeners = new ListenerSupport();
    private final ListenerSupport<ConnectionAgentListener> m_connectionAgentListener = new ListenerSupport();
    private final ListenerSupport<ConnectionAgentCommunicationListener> m_connectionAgentCommunicationListener = new ListenerSupport();
    private static final Logger LOGGER = LoggerFactory.getLogger(AgentProcessControlImplementation.class);
    private static final long UPDATE_PERIOD = 500L;
    private static final long FLUSH_PERIOD = 2000L;
    private volatile boolean m_newData = false;

    public AgentProcessControlImplementation(Timer timer, ConsoleCommunication consoleCommunication) {
        this.m_consoleCommunication = consoleCommunication;
        timer.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Map map = AgentProcessControlImplementation.this.m_agentMap;
                synchronized (map) {
                    try {
                        AgentProcessControlImplementation.this.update();
                    }
                    catch (Exception e) {
                        LOGGER.error("Error occurred during update agent", (Throwable)e);
                    }
                }
            }
        }, 0L, 500L);
        timer.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Map map = AgentProcessControlImplementation.this.m_agentMap;
                synchronized (map) {
                    try {
                        AgentProcessControlImplementation.this.purge(AgentProcessControlImplementation.this.m_agentMap);
                    }
                    catch (Exception e) {
                        LOGGER.error("Error occurred during purge agent", (Throwable)e);
                    }
                }
            }
        }, 0L, 2000L);
        MessageDispatchRegistry messageDispatchRegistry = consoleCommunication.getMessageDispatchRegistry();
        messageDispatchRegistry.set(AgentControllerProcessReportMessage.class, (MessageDispatchRegistry.Handler)new MessageDispatchRegistry.AbstractHandler<AgentControllerProcessReportMessage>(){

            public void handle(AgentControllerProcessReportMessage message) {
                AgentProcessControlImplementation.this.updateAgentProcessReportMessage(message);
            }
        });
        messageDispatchRegistry.set(LogReportGrinderMessage.class, (MessageDispatchRegistry.Handler)new MessageDispatchRegistry.AbstractHandler<LogReportGrinderMessage>(){

            public void handle(final LogReportGrinderMessage message) {
                AgentProcessControlImplementation.this.m_logListeners.apply((ListenerSupport.Informer)new ListenerSupport.Informer<LogArrivedListener>(){

                    public void inform(LogArrivedListener listener) {
                        listener.logArrived(message.getTestId(), message.getAddress(), message.getLogs());
                    }
                });
            }
        });
        messageDispatchRegistry.set(AgentDownloadGrinderMessage.class, (MessageDispatchRegistry.Handler)new MessageDispatchRegistry.AbstractHandler<AgentDownloadGrinderMessage>(){

            public void handle(final AgentDownloadGrinderMessage message) {
                AgentProcessControlImplementation.this.m_agentDownloadRequestListeners.apply((ListenerSupport.Informer)new ListenerSupport.Informer<AgentDownloadRequestListener>(){

                    public void inform(AgentDownloadRequestListener listener) {
                        AgentUpdateGrinderMessage agentUpdateGrinderMessage = listener.onAgentDownloadRequested(message.getVersion(), message.getNext());
                        if (agentUpdateGrinderMessage != null) {
                            AgentProcessControlImplementation.this.m_consoleCommunication.sendToAddressedAgents(message.getAddress(), (Message)agentUpdateGrinderMessage);
                        }
                    }
                });
            }
        });
        messageDispatchRegistry.set(ConnectionAgentMessage.class, (MessageDispatchRegistry.Handler)new MessageDispatchRegistry.AbstractHandler<ConnectionAgentMessage>(){

            public void handle(final ConnectionAgentMessage message) {
                AgentProcessControlImplementation.this.m_connectionAgentListener.apply((ListenerSupport.Informer)new ListenerSupport.Informer<ConnectionAgentListener>(){

                    public void inform(ConnectionAgentListener listener) {
                        listener.onConnectionAgentMessage(message.getIp(), message.getName(), message.getPort());
                    }
                });
            }
        });
        messageDispatchRegistry.set(ConnectionAgentCommunicationMessage.class, (MessageDispatchRegistry.Handler)new MessageDispatchRegistry.AbstractHandler<ConnectionAgentCommunicationMessage>(){

            public void handle(final ConnectionAgentCommunicationMessage message) {
                AgentProcessControlImplementation.this.m_connectionAgentCommunicationListener.apply((ListenerSupport.Informer)new ListenerSupport.Informer<ConnectionAgentCommunicationListener>(){

                    public void inform(ConnectionAgentCommunicationListener listener) {
                        listener.onConnectionAgentCommunication(message.getUsingPort(), message.getIp(), message.getPort());
                    }
                });
            }
        });
    }

    private void updateAgentProcessReportMessage(AgentControllerProcessReportMessage message) {
        AgentIdentity agentIdentity = message.getAgentIdentity();
        AgentStatus agentStatus = this.getAgentStatus(agentIdentity);
        agentStatus.setAgentProcessStatus(message);
        this.m_agentMap.put(agentIdentity, agentStatus);
        this.m_newData = true;
    }

    private AgentStatus getAgentStatus(AgentIdentity agentIdentity) {
        return this.m_agentMap.getOrDefault(agentIdentity, new AgentStatus(agentIdentity));
    }

    private void update() {
        if (!this.m_newData) {
            return;
        }
        this.m_newData = false;
        this.m_agentStatusUpdateListeners.apply((ListenerSupport.Informer)new ListenerSupport.Informer<AgentStatusUpdateListener>(){

            public void inform(AgentStatusUpdateListener agentStatusUpdateListener) {
                agentStatusUpdateListener.update(Collections.unmodifiableMap(AgentProcessControlImplementation.this.m_agentMap));
            }
        });
    }

    public void addAgentDownloadRequestListener(AgentDownloadRequestListener agentDownloadRequestListener) {
        this.m_agentDownloadRequestListeners.add((Object)agentDownloadRequestListener);
    }

    public void addConnectionAgentListener(ConnectionAgentListener connectionAgentListener) {
        this.m_connectionAgentListener.add((Object)connectionAgentListener);
    }

    public void addConnectionAgentCommunicationListener(ConnectionAgentCommunicationListener listener) {
        this.m_connectionAgentCommunicationListener.add((Object)listener);
    }

    private void purge(Map<? extends ProcessIdentity, ? extends Purgable> purgableMap) {
        HashSet<ProcessIdentity> zombies = new HashSet<ProcessIdentity>();
        for (Map.Entry<? extends ProcessIdentity, ? extends Purgable> entry : purgableMap.entrySet()) {
            if (!entry.getValue().shouldPurge()) continue;
            zombies.add(entry.getKey());
        }
        if (zombies.size() > 0) {
            for (ProcessIdentity processIdentity : zombies) {
                purgableMap.remove(processIdentity);
            }
            this.m_newData = true;
        }
    }

    public void addAgentStatusUpdateListener(AgentStatusUpdateListener agentStatusUpdateListener) {
        this.m_agentStatusUpdateListeners.add((Object)agentStatusUpdateListener);
    }

    public void addLogArrivedListener(LogArrivedListener listener) {
        this.m_logListeners.add((Object)listener);
    }

    @Override
    public void startAgent(Set<AgentIdentity> agents, GrinderProperties properties) {
        GrinderProperties propertiesToSend = properties != null ? properties : new GrinderProperties();
        for (AgentIdentity each : agents) {
            this.m_consoleCommunication.sendToAddressedAgents((Address)new AgentAddress(each), (Message)new StartGrinderMessage(propertiesToSend, each.getNumber()));
        }
    }

    @Override
    public void stopAgent(AgentIdentity agentIdentity) {
        this.m_consoleCommunication.sendToAddressedAgents((Address)new AgentAddress(agentIdentity), (Message)new StopGrinderMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumberOfLiveAgents() {
        Map<AgentIdentity, AgentStatus> map = this.m_agentMap;
        synchronized (map) {
            return this.m_agentMap.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<AgentIdentity> getAgents(AgentControllerState state, int count) {
        count = count == 0 ? Integer.MAX_VALUE : count;
        Map<AgentIdentity, AgentStatus> map = this.m_agentMap;
        synchronized (map) {
            int i = 0;
            HashSet<AgentIdentity> agents = new HashSet<AgentIdentity>();
            for (Map.Entry<AgentIdentity, AgentStatus> each : this.m_agentMap.entrySet()) {
                if (!each.getValue().getAgentControllerState().equals((Object)state) || ++i > count) continue;
                agents.add(each.getKey());
            }
            return agents;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<AgentIdentity> getAllAgents() {
        Map<AgentIdentity, AgentStatus> map = this.m_agentMap;
        synchronized (map) {
            return this.m_agentMap.keySet();
        }
    }

    @Override
    public AgentControllerState getAgentControllerState(AgentIdentity agentIdentity) {
        return this.getAgentStatus(agentIdentity).getAgentControllerState();
    }

    @Override
    public String getAgentVersion(AgentIdentity agentIdentity) {
        return this.getAgentStatus(agentIdentity).getVersion();
    }

    @Override
    public SystemDataModel getSystemDataModel(AgentIdentity agentIdentity) {
        return this.getAgentStatus(agentIdentity).getSystemDataModel();
    }

    @Override
    public int getAgentConnectingPort(AgentIdentity agentIdentity) {
        return this.getAgentStatus(agentIdentity).getConnectingPort();
    }

    public Set<AgentStatus> getAgentStatusSet(Predicate<AgentStatus> predicate) {
        Set<AgentStatus> statusSet = CollectionUtils.newLinkedHashSet();
        for (Map.Entry<AgentIdentity, AgentStatus> each : this.m_agentMap.entrySet()) {
            if (!predicate.test(each.getValue())) continue;
            statusSet.add(each.getValue());
        }
        return statusSet;
    }

    private static class UnknownAgentProcessReport
    extends AgentControllerProcessReportMessage {
        private static final long serialVersionUID = -2758014000696737553L;

        public UnknownAgentProcessReport(AgentAddress address) {
            super(AgentControllerState.UNKNOWN, null, 0, null);
            try {
                this.setAddress((Address)address);
            }
            catch (CommunicationException e) {
                LOGGER.error("Error while setAdress" + address, (Throwable)e);
            }
        }

        @Override
        public AgentControllerState getState() {
            return AgentControllerState.UNKNOWN;
        }
    }

    public final class AgentStatus
    implements Purgable {
        private volatile AgentReference m_agentReference;

        public AgentStatus(AgentIdentity agentIdentity) {
            this.setAgentProcessStatus(new UnknownAgentProcessReport(new AgentAddress(agentIdentity)));
        }

        @Override
        public boolean shouldPurge() {
            return this.m_agentReference.shouldPurge();
        }

        public AgentControllerState getAgentControllerState() {
            if (this.m_agentReference == null) {
                return AgentControllerState.UNKNOWN;
            }
            AgentControllerProcessReportMessage agentProcessReport = this.m_agentReference.m_agentProcessReportMessage;
            return agentProcessReport == null ? AgentControllerState.UNKNOWN : agentProcessReport.getState();
        }

        public void setAgentProcessStatus(AgentControllerProcessReportMessage message) {
            this.m_agentReference = new AgentReference(message);
        }

        public String getVersion() {
            return this.m_agentReference == null ? null : this.m_agentReference.m_agentProcessReportMessage.getVersion();
        }

        public SystemDataModel getSystemDataModel() {
            return this.m_agentReference == null ? null : this.m_agentReference.m_agentProcessReportMessage.getSystemDataModel();
        }

        public int getConnectingPort() {
            return this.m_agentReference == null ? 0 : this.m_agentReference.m_agentProcessReportMessage.getConnectingPort();
        }

        public AgentIdentity getAgentIdentity() {
            return this.m_agentReference == null ? null : this.m_agentReference.m_agentProcessReportMessage.getAgentIdentity();
        }

        public String getAgentName() {
            return this.m_agentReference == null ? "" : this.m_agentReference.m_agentProcessReportMessage.getAgentIdentity().getName();
        }
    }

    private final class AgentReference
    extends AbstractTimedReference {
        private final AgentControllerProcessReportMessage m_agentProcessReportMessage;

        AgentReference(AgentControllerProcessReportMessage agentProcessReportMessage) {
            this.m_agentProcessReportMessage = agentProcessReportMessage;
        }
    }

    private abstract class AbstractTimedReference
    implements Purgable {
        private int m_purgeDelayCount;

        private AbstractTimedReference() {
        }

        @Override
        public boolean shouldPurge() {
            if (this.m_purgeDelayCount > 0) {
                return true;
            }
            ++this.m_purgeDelayCount;
            return false;
        }

        public void initPurgeDelayCount() {
            this.m_purgeDelayCount = 0;
        }
    }

    private static interface Purgable {
        public boolean shouldPurge();
    }

    public static interface AgentStatusUpdateListener
    extends EventListener {
        public void update(Map<AgentIdentity, AgentStatus> var1);
    }
}

