/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.engine.communication;

import net.grinder.communication.Message;
import net.grinder.communication.MessageDispatchRegistry;
import net.grinder.engine.communication.AgentUpdateGrinderMessage;
import net.grinder.messages.agent.StartGrinderMessage;
import net.grinder.messages.agent.StopGrinderMessage;
import net.grinder.util.thread.Condition;
import org.slf4j.Logger;

public final class AgentControllerServerListener {
    public static final int START = 1;
    public static final int RESET = 2;
    public static final int STOP = 4;
    public static final int SHUTDOWN = 8;
    public static final int AGENT_UPDATE = 16;
    public static final int ANY = 31;
    private final Condition m_notifyOnMessage;
    private final Logger m_logger;
    private int m_messagesReceived = 0;
    private int m_lastMessagesReceived = 0;
    private StartGrinderMessage m_lastStartGrinderMessage;
    private AgentUpdateGrinderMessage m_lastAgentUpdateGrinderMessage;

    public AgentControllerServerListener(Condition notifyOnMessage, Logger logger) {
        this.m_notifyOnMessage = notifyOnMessage;
        this.m_logger = logger;
    }

    public void shutdown() {
        this.setReceived(8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForMessage() {
        while (!this.checkForMessage(31)) {
            Condition condition = this.m_notifyOnMessage;
            synchronized (condition) {
                this.m_notifyOnMessage.waitNoInterrruptException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkForMessage(int mask) {
        AgentControllerServerListener agentControllerServerListener = this;
        synchronized (agentControllerServerListener) {
            int intersection = this.m_messagesReceived & mask;
            try {
                this.m_lastMessagesReceived = intersection;
            }
            finally {
                this.m_messagesReceived ^= intersection;
            }
        }
        return this.received(mask | 8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discardMessages(int mask) {
        AgentControllerServerListener agentControllerServerListener = this;
        synchronized (agentControllerServerListener) {
            this.m_lastMessagesReceived &= ~mask;
            this.m_messagesReceived &= ~mask;
        }
    }

    public synchronized boolean received(int mask) {
        return (this.m_lastMessagesReceived & mask) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setReceived(int message) {
        AgentControllerServerListener agentControllerServerListener = this;
        synchronized (agentControllerServerListener) {
            this.m_messagesReceived |= message;
        }
        agentControllerServerListener = this.m_notifyOnMessage;
        synchronized (agentControllerServerListener) {
            this.m_notifyOnMessage.notifyAll();
        }
    }

    public void registerMessageHandlers(MessageDispatchRegistry messageDispatcher) {
        messageDispatcher.set(StartGrinderMessage.class, (MessageDispatchRegistry.Handler)new AbstractMessageHandler<StartGrinderMessage>(){

            public void handle(StartGrinderMessage message) {
                AgentControllerServerListener.this.m_logger.info("Received a start agent message");
                AgentControllerServerListener.this.m_lastStartGrinderMessage = message;
                AgentControllerServerListener.this.setReceived(1);
            }
        });
        messageDispatcher.set(StopGrinderMessage.class, (MessageDispatchRegistry.Handler)new AbstractMessageHandler<StopGrinderMessage>(){

            public void handle(StopGrinderMessage message) {
                AgentControllerServerListener.this.m_logger.info("Received a stop agent message");
                AgentControllerServerListener.this.setReceived(4);
            }
        });
        messageDispatcher.set(AgentUpdateGrinderMessage.class, (MessageDispatchRegistry.Handler)new AbstractMessageHandler<AgentUpdateGrinderMessage>(){

            public void handle(AgentUpdateGrinderMessage message) {
                AgentControllerServerListener.this.m_logger.info("Received a agent update message {}", (Object)message.getNext());
                AgentControllerServerListener.this.m_lastAgentUpdateGrinderMessage = message;
                AgentControllerServerListener.this.setReceived(16);
            }
        });
    }

    public StartGrinderMessage getLastStartGrinderMessage() {
        return this.m_lastStartGrinderMessage;
    }

    public AgentUpdateGrinderMessage getLastAgentUpdateGrinderMessage() {
        return this.m_lastAgentUpdateGrinderMessage;
    }

    private abstract class AbstractMessageHandler<T extends Message>
    implements MessageDispatchRegistry.Handler<T> {
        private AbstractMessageHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            boolean shutdown;
            AgentControllerServerListener agentControllerServerListener = AgentControllerServerListener.this;
            synchronized (agentControllerServerListener) {
                shutdown = (AgentControllerServerListener.this.m_messagesReceived & 8) == 0;
            }
            if (shutdown) {
                AgentControllerServerListener.this.m_logger.info("agent controller communication is shutdown");
                AgentControllerServerListener.this.setReceived(8);
            }
        }
    }
}

