/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.util;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.ngrinder.common.util.CollectionUtils;
import org.ngrinder.common.util.EncodingUtils;
import org.ngrinder.common.util.Preconditions;
import org.slf4j.Logger;

public abstract class AbstractGrinderClassPathProcessor {
    private final List<String> foreMostJarList = CollectionUtils.newArrayList();
    private final List<String> patchJarList = CollectionUtils.newArrayList();
    private final List<String> usefulJarList = CollectionUtils.newArrayList();
    private final List<String> uselessJarList = CollectionUtils.newArrayList();
    private static boolean junitContext = false;

    public AbstractGrinderClassPathProcessor() {
        this.init();
        this.initMore();
    }

    static void setJUnitContext() {
        junitContext = true;
    }

    public String filterClassPath(String classPath, Logger logger) {
        ArrayList<String> classPathList = new ArrayList<String>();
        for (String eachClassPath : Preconditions.checkNotNull(classPath).split(File.pathSeparator)) {
            String filename = FilenameUtils.getName((String)eachClassPath);
            if (!this.isUsefulJar(filename) && !this.isUsefulReferenceProject(eachClassPath)) continue;
            logger.trace("classpath :" + eachClassPath);
            classPathList.add(eachClassPath);
        }
        return StringUtils.join(classPathList, (String)File.pathSeparator);
    }

    private boolean isUsefulReferenceProject(String path) {
        return junitContext && new File(path).isDirectory() && path.contains(File.separator + "ngrinder-groovy" + File.separator);
    }

    public String filterForeMostClassPath(String classPath, Logger logger) {
        ArrayList<String> classPathList = new ArrayList<String>();
        for (String eachClassPath : Preconditions.checkNotNull(classPath).split(File.pathSeparator)) {
            String filename = FilenameUtils.getName((String)eachClassPath);
            if (!this.isForemostJar(filename) && !this.isUsefulForForemostReferenceProject(eachClassPath)) continue;
            logger.trace("classpath :" + eachClassPath);
            classPathList.add(eachClassPath);
        }
        return StringUtils.join(classPathList, (String)File.pathSeparator);
    }

    public String filterPatchClassPath(String classPath, Logger logger) {
        ArrayList<String> classPathList = new ArrayList<String>();
        for (String eachClassPath : Preconditions.checkNotNull(classPath).split(File.pathSeparator)) {
            String filename = FilenameUtils.getName((String)eachClassPath);
            if (!this.isPatchJar(filename)) continue;
            logger.trace("classpath :" + eachClassPath);
            classPathList.add(eachClassPath);
        }
        return StringUtils.join(classPathList, (String)File.pathSeparator);
    }

    private boolean isUsefulForForemostReferenceProject(String path) {
        return junitContext && new File(path).isDirectory() && path.contains(File.separator + "ngrinder-runtime" + File.separator);
    }

    private boolean isPatchJar(String jarFilename) {
        if ("jar".equals(FilenameUtils.getExtension((String)jarFilename))) {
            for (String jarName : this.patchJarList) {
                if (!jarFilename.contains(jarName)) continue;
                return true;
            }
        }
        return false;
    }

    public void init() {
        this.foreMostJarList.add("ngrinder-runtime");
        this.patchJarList.add("patch");
        this.usefulJarList.add("grinder");
        this.usefulJarList.add("dnsjava");
        this.usefulJarList.add("asm");
        this.usefulJarList.add("picocontainer");
        this.usefulJarList.add("slf4j-api");
        this.usefulJarList.add("json");
        this.usefulJarList.add("logback");
        this.usefulJarList.add("jna");
        this.usefulJarList.add("jsr173");
        this.usefulJarList.add("xmlbeans");
        this.usefulJarList.add("stax-api");
        this.usefulJarList.add("ngrinder-patch");
        this.usefulJarList.add("junit");
        this.usefulJarList.add("hamcrest");
        this.usefulJarList.add("commons-lang");
        this.uselessJarList.add("jython-2.2");
        this.uselessJarList.add("ngrinder-core");
        this.uselessJarList.add("ngrinder-controller");
        this.uselessJarList.add("ngrinder-groovy");
        this.uselessJarList.add("spring");
    }

    protected abstract void initMore();

    private boolean isForemostJar(String jarFilename) {
        if ("jar".equals(FilenameUtils.getExtension((String)jarFilename))) {
            for (String jarName : this.foreMostJarList) {
                if (!jarFilename.contains(jarName)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isUsefulJar(String jarFilename) {
        if (this.isPatchJar(jarFilename)) {
            return false;
        }
        if (!"jar".equals(FilenameUtils.getExtension((String)jarFilename))) {
            return false;
        }
        for (String jarName : this.uselessJarList) {
            if (!jarFilename.contains(jarName)) continue;
            return false;
        }
        for (String jarName : this.usefulJarList) {
            if (!jarFilename.contains(jarName)) continue;
            return true;
        }
        return false;
    }

    public String buildForemostClasspathBasedOnCurrentClassLoader(Logger logger) {
        URL[] urLs = ((URLClassLoader)AbstractGrinderClassPathProcessor.class.getClassLoader()).getURLs();
        StringBuilder builder = new StringBuilder();
        for (URL each : urLs) {
            builder.append(EncodingUtils.decodePathWithUTF8(each.getFile())).append(File.pathSeparator);
        }
        return this.filterForeMostClassPath(builder.toString(), logger);
    }

    public String buildPatchClasspathBasedOnCurrentClassLoader(Logger logger) {
        URL[] urLs = ((URLClassLoader)AbstractGrinderClassPathProcessor.class.getClassLoader()).getURLs();
        StringBuilder builder = new StringBuilder();
        for (URL each : urLs) {
            builder.append(EncodingUtils.decodePathWithUTF8(each.getFile())).append(File.pathSeparator);
        }
        return this.filterPatchClassPath(builder.toString(), logger);
    }

    public String buildClasspathBasedOnCurrentClassLoader(Logger logger) {
        URL[] urls = ((URLClassLoader)AbstractGrinderClassPathProcessor.class.getClassLoader()).getURLs();
        StringBuilder builder = new StringBuilder();
        for (URL each : urls) {
            builder.append(EncodingUtils.decodePathWithUTF8(each.getFile())).append(File.pathSeparator);
        }
        if (builder.length() < 300) {
            String property = System.getProperty("java.class.path", "");
            for (String each : property.split(File.pathSeparator)) {
                builder.append(each).append(File.pathSeparator);
            }
        }
        return this.filterClassPath(builder.toString(), logger);
    }

    public List<String> getUsefulJarList() {
        return this.usefulJarList;
    }

    public List<String> getUselessJarList() {
        return this.uselessJarList;
    }
}

