/*
 * Decompiled with CFR 0.152.
 */
package org.ngrinder;

import com.beust.jcommander.DynamicParameter;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

@Parameters(separators="= ")
public class NGrinderAgentStarterParam {
    @Parameter(names={"-m", "-mode", "--mode"}, required=false, description="run mode. The agent/monitor modes are available.", hidden=true)
    public String mode = null;
    @Parameter(names={"-c", "-command", "--command"}, required=false, description="execution command. The stop/start command are available.", hidden=true)
    public String command = "start";

    public NGrinderModeParam getModeParam() {
        return NGrinderModeParam.valueOf(this.mode);
    }

    @Parameters(separators="= ")
    public static enum NGrinderModeParam {
        agent("run_agent"){
            @Parameter(names={"-ch", "--controller-host"}, required=false, description="controller host or ip.")
            public String controllerHost = null;
            @Parameter(names={"-cp", "--controller-port"}, required=false, description="controller port.")
            public Integer controllerPort = null;
            @Parameter(names={"-r", "--region"}, required=false, description="region")
            public String region = null;
            @Parameter(names={"-hi", "--host-id"}, required=false, description="this agent's unique host id")
            public String hostId = null;

            @Override
            protected void processInternal() {
                if (this.controllerHost != null) {
                    System.setProperty("agent.controller_host", this.controllerHost);
                }
                if (this.controllerPort != null) {
                    System.setProperty("agent.controller_port", this.controllerPort.toString());
                }
                if (this.hostId != null) {
                    System.setProperty("agent.host_id", this.hostId);
                }
                if (this.region != null) {
                    System.setProperty("agent.region", this.region);
                }
            }
        }
        ,
        monitor("run_monitor"){

            @Override
            protected void processInternal() {
            }
        };

        @Parameter(names={"-ah", "--agent-home"}, required=false, description="this agent's unique home path. The default is ~/.ngrinder_agent")
        public String agentHome = null;
        @Parameter(names={"-s", "--silent"}, description="silent mode")
        public Boolean silent = null;
        @Parameter(names={"-v", "--version"}, description="show version")
        public Boolean version = null;
        @DynamicParameter(names={"-D"}, description="dynamic parameters", hidden=true)
        public Map<String, String> params = new HashMap<String, String>();
        @Parameter(names={"-help", "-?", "-h"}, description="prints this message")
        public Boolean help = null;
        private JCommander commander = new JCommander((Object)this);

        private NGrinderModeParam(String programName) {
            this.commander.setProgramName(programName + (File.separator.equals("/") ? ".sh" : ".bat"));
        }

        public void parse(String[] args) {
            try {
                this.commander.parse(args);
                this.process();
            }
            catch (Exception e) {
                System.err.println("[Configuration Error]");
                System.err.println(e.getMessage());
                this.usage();
                System.exit(-1);
            }
        }

        public void process() {
            if (this.agentHome != null) {
                System.setProperty("ngrinder.agent.home", this.agentHome);
            }
            if (this.silent != null) {
                System.setProperty("common.silent_mode", "true");
            }
            this.processInternal();
        }

        protected abstract void processInternal();

        public void usage() {
            this.commander.usage();
        }
    }
}

