/*
 * Decompiled with CFR 0.152.
 */
package org.ngrinder.common.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.ngrinder.common.util.ExceptionUtils;
import org.ngrinder.common.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CompressionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompressionUtils.class);
    public static final List<String> EXECUTABLE_EXTENSION = Arrays.asList("bat", "sh");

    public static void unzip(File zippedFile, String charsetName) {
        CompressionUtils.unzip(zippedFile, zippedFile.getParentFile(), charsetName);
    }

    public static void unzip(File zippedFile, File destDir) {
        try {
            CompressionUtils.unzip(new FileInputStream(zippedFile), destDir, Charset.defaultCharset().name());
        }
        catch (FileNotFoundException e) {
            throw ExceptionUtils.processException(e);
        }
    }

    public static void unzip(File zippedFile, File destDir, String charsetName) {
        try {
            CompressionUtils.unzip(new FileInputStream(zippedFile), destDir, charsetName);
        }
        catch (FileNotFoundException e) {
            throw ExceptionUtils.processException(e);
        }
    }

    public static void unzip(InputStream is, File destDir) {
        CompressionUtils.unzip(is, destDir, Charset.defaultCharset().name());
    }

    public static void unzip(InputStream is, File destDir, String charsetName) {
        byte[] buffer = new byte[1024];
        ZipInputStream zis = null;
        FileOutputStream fos = null;
        try {
            File folder = destDir;
            if (!folder.exists()) {
                folder.mkdir();
            }
            zis = new ZipInputStream(is);
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                String fileName = ze.getName();
                File newFile = new File(destDir.getAbsolutePath(), fileName);
                if (newFile.getPath().contains("..")) {
                    throw new IllegalArgumentException("zip entry should not contain .. in the path.");
                }
                if (ze.isDirectory()) {
                    newFile.mkdirs();
                } else {
                    int len;
                    fos = new FileOutputStream(newFile);
                    while ((len = zis.read(buffer)) > 0) {
                        fos.write(buffer, 0, len);
                    }
                    IOUtils.closeQuietly((OutputStream)fos);
                }
                ze = zis.getNextEntry();
            }
        }
        catch (Exception e) {
            try {
                throw ExceptionUtils.processException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fos);
                IOUtils.closeQuietly((InputStream)is);
                IOUtils.closeQuietly(zis);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(fos);
        IOUtils.closeQuietly((InputStream)is);
        IOUtils.closeQuietly((InputStream)zis);
    }

    public static void zip(File src) throws IOException {
        CompressionUtils.zip(src, Charset.defaultCharset().name(), true);
    }

    public static void zip(File src, boolean includeSrc) throws IOException {
        CompressionUtils.zip(src, Charset.defaultCharset().name(), includeSrc);
    }

    public static void zip(File src, String charSetName, boolean includeSrc) throws IOException {
        CompressionUtils.zip(src, src.getParentFile(), charSetName, includeSrc);
    }

    public static void zip(File src, OutputStream os) throws IOException {
        CompressionUtils.zip(src, os, Charset.defaultCharset().name(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zip(File src, File destDir, String charSetName, boolean includeSrc) throws IOException {
        File zippedFile;
        int pos;
        String fileName = src.getName();
        if (!src.isDirectory() && (pos = fileName.lastIndexOf(".")) > 0) {
            fileName = fileName.substring(0, pos);
        }
        if (!(zippedFile = new File(destDir, fileName = fileName + ".zip")).exists()) {
            zippedFile.createNewFile();
        }
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(zippedFile);
            CompressionUtils.zip(src, os, charSetName, includeSrc);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(os);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zip(File src, OutputStream os, String charsetName, boolean includeSrc) throws IOException {
        File root;
        ZipArchiveOutputStream zos = new ZipArchiveOutputStream(os);
        zos.setEncoding(charsetName);
        FileInputStream fis = null;
        byte[] buf = new byte[8192];
        Stack<File> stack = new Stack<File>();
        if (src.isDirectory()) {
            if (includeSrc) {
                stack.push(src);
                root = src.getParentFile();
            } else {
                File[] fs = Preconditions.checkNotNull(src.listFiles());
                for (int i = 0; i < fs.length; ++i) {
                    stack.push(fs[i]);
                }
                root = src;
            }
        } else {
            stack.push(src);
            root = src.getParentFile();
        }
        while (!stack.isEmpty()) {
            File f = (File)stack.pop();
            String name = CompressionUtils.toPath(root, f);
            if (f.isDirectory()) {
                File[] fs = Preconditions.checkNotNull(f.listFiles());
                for (int i = 0; i < fs.length; ++i) {
                    if (fs[i].isDirectory()) {
                        stack.push(fs[i]);
                        continue;
                    }
                    stack.add(0, fs[i]);
                }
                continue;
            }
            ZipArchiveEntry ze = new ZipArchiveEntry(name);
            zos.putArchiveEntry((ArchiveEntry)ze);
            try {
                int length;
                fis = new FileInputStream(f);
                while ((length = fis.read(buf, 0, buf.length)) >= 0) {
                    zos.write(buf, 0, length);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fis);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)fis);
            zos.closeArchiveEntry();
        }
        zos.close();
    }

    private static String toPath(File root, File dir) {
        String path = dir.getAbsolutePath();
        if ((path = path.substring(root.getAbsolutePath().length()).replace(File.separatorChar, '/')).startsWith("/")) {
            path = path.substring(1);
        }
        if (dir.isDirectory() && !path.endsWith("/")) {
            path = path + "/";
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<File> untar(File inFile, File outputDir) {
        LinkedList<File> untaredFiles = new LinkedList<File>();
        FileInputStream is = null;
        TarArchiveInputStream debInputStream = null;
        try {
            TarArchiveEntry entry;
            is = new FileInputStream(inFile);
            debInputStream = (TarArchiveInputStream)new ArchiveStreamFactory().createArchiveInputStream("tar", (InputStream)is);
            while ((entry = (TarArchiveEntry)debInputStream.getNextEntry()) != null) {
                File outputFile = new File(outputDir, entry.getName());
                if (entry.isDirectory()) {
                    if (!outputFile.exists() && !outputFile.mkdirs()) {
                        throw new IllegalStateException(String.format("Couldn't create directory %s.", outputFile.getAbsolutePath()));
                    }
                } else {
                    File parentFile = outputFile.getParentFile();
                    if (!parentFile.exists()) {
                        parentFile.mkdirs();
                    }
                    FileOutputStream outputFileStream = new FileOutputStream(outputFile);
                    try {
                        IOUtils.copy((InputStream)debInputStream, (OutputStream)outputFileStream);
                    }
                    finally {
                        IOUtils.closeQuietly((OutputStream)outputFileStream);
                    }
                    if (FilenameUtils.isExtension((String)outputFile.getName(), EXECUTABLE_EXTENSION)) {
                        outputFile.setExecutable(true, true);
                    }
                    outputFile.setReadable(true);
                    outputFile.setWritable(true, true);
                }
                untaredFiles.add(outputFile);
            }
        }
        catch (Exception e) {
            try {
                throw ExceptionUtils.processException("Error while untar file", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                IOUtils.closeQuietly(debInputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        IOUtils.closeQuietly((InputStream)debInputStream);
        return untaredFiles;
    }

    public static File ungzip(File inFile, File outFile) {
        FileInputStream fin = null;
        BufferedInputStream in = null;
        FileOutputStream fout = null;
        GzipCompressorInputStream gzIn = null;
        try {
            int n;
            fin = new FileInputStream(inFile);
            in = new BufferedInputStream(fin);
            gzIn = new GzipCompressorInputStream((InputStream)in);
            if (!outFile.getParentFile().exists()) {
                outFile.getParentFile().mkdirs();
            }
            fout = new FileOutputStream(outFile);
            byte[] buffer = new byte[4048];
            while (-1 != (n = gzIn.read(buffer))) {
                fout.write(buffer, 0, n);
            }
        }
        catch (Exception e) {
            try {
                throw ExceptionUtils.processException("Error while ungzip file", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fin);
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly(fout);
                IOUtils.closeQuietly(gzIn);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)fin);
        IOUtils.closeQuietly((InputStream)in);
        IOUtils.closeQuietly((OutputStream)fout);
        IOUtils.closeQuietly((InputStream)gzIn);
        return outFile;
    }

    public static void processJarEntries(File jarFile, ZipEntryProcessor processor) {
        try {
            JarFile jarfile = new JarFile(jarFile);
            Enumeration<JarEntry> enu = jarfile.entries();
            while (enu.hasMoreElements()) {
                JarEntry je = enu.nextElement();
                if (je.isDirectory()) continue;
                processor.process(jarfile, je);
            }
        }
        catch (IOException e) {
            throw ExceptionUtils.processException("Error while extracting jar file", e);
        }
    }

    public static void addFileToTar(TarArchiveOutputStream tarStream, File file, String path) throws IOException {
        int mode = file.isDirectory() ? 16877 : 33188;
        CompressionUtils.addFileToTar(tarStream, file, path, mode);
    }

    public static void addFolderToTar(TarArchiveOutputStream tarStream, String path) throws IOException {
        TarArchiveEntry archiveEntry = new TarArchiveEntry(path);
        archiveEntry.setMode(16877);
        tarStream.putArchiveEntry((ArchiveEntry)archiveEntry);
        tarStream.closeArchiveEntry();
    }

    public static void addInputStreamToTar(TarArchiveOutputStream tarStream, InputStream inputStream, String path, long size, int mode) throws IOException {
        TarArchiveEntry entry = new TarArchiveEntry(path);
        entry.setSize(size);
        entry.setMode(mode);
        try {
            tarStream.putArchiveEntry((ArchiveEntry)entry);
            IOUtils.copy((InputStream)inputStream, (OutputStream)tarStream);
        }
        catch (IOException e) {
            throw ExceptionUtils.processException("Error while adding File to Tar file", e);
        }
        finally {
            tarStream.closeArchiveEntry();
        }
    }

    public static void addByteToTar(TarArchiveOutputStream tarArchiveOutputStream, byte[] data, String path, long size, int mode) throws IOException {
        TarArchiveEntry entry = new TarArchiveEntry(path);
        entry.setSize(size);
        entry.setMode(mode);
        try {
            tarArchiveOutputStream.putArchiveEntry((ArchiveEntry)entry);
            tarArchiveOutputStream.write(data);
        }
        catch (IOException e) {
            throw ExceptionUtils.processException("Error while adding File to Tar file", e);
        }
        finally {
            tarArchiveOutputStream.closeArchiveEntry();
        }
    }

    public static void addFileToTar(TarArchiveOutputStream tarStream, File file, String path, int mode) throws IOException {
        TarArchiveEntry entry = new TarArchiveEntry(path);
        entry.setSize(file.length());
        entry.setMode(mode);
        BufferedInputStream bis = null;
        try {
            tarStream.putArchiveEntry((ArchiveEntry)entry);
            bis = new BufferedInputStream(new FileInputStream(file));
            IOUtils.copy((InputStream)bis, (OutputStream)tarStream);
        }
        catch (IOException e) {
            try {
                throw ExceptionUtils.processException("Error while adding File to Tar file", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bis);
                tarStream.closeArchiveEntry();
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)bis);
        tarStream.closeArchiveEntry();
    }

    public static interface FilePredicate {
        public boolean evaluate(Object var1);
    }

    public static interface ZipEntryProcessor {
        public void process(ZipFile var1, ZipEntry var2) throws IOException;
    }
}

