/*
 * Decompiled with CFR 0.152.
 */
package org.ngrinder.common.util;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.ngrinder.common.util.Preconditions;

public class PropertiesKeyMapper {
    private Map<String, List<String>> keyMaps = new HashMap<String, List<String>>();
    private Map<String, String> defaultValues = new HashMap<String, String>();

    private PropertiesKeyMapper() {
    }

    public PropertiesKeyMapper init(String propertyMapName) {
        InputStream is = Preconditions.checkNotNull(PropertiesKeyMapper.class.getClassLoader().getResourceAsStream(propertyMapName));
        Scanner scanner = new Scanner(is);
        while (scanner.hasNextLine()) {
            String line = StringUtils.trimToEmpty((String)scanner.nextLine());
            if (line.isEmpty() || line.startsWith("#")) continue;
            String[] split = line.split(",");
            String key = null;
            ArrayList<String> values = new ArrayList<String>();
            for (int i = 0; i < split.length; ++i) {
                if (i == 0) {
                    key = split[0];
                    this.keyMaps.put(key, values);
                    continue;
                }
                if (i == 1) {
                    this.defaultValues.put(key, StringUtils.trimToNull((String)split[1]));
                    continue;
                }
                values.add(split[i]);
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        return this;
    }

    public static PropertiesKeyMapper create(String mapName) {
        return new PropertiesKeyMapper().init(mapName);
    }

    public List<String> getKeys(String key) {
        return this.keyMaps.get(key);
    }

    public String getDefaultValue(String key) {
        return this.defaultValues.get(key);
    }

    public Set<String> getAllKeys() {
        return this.keyMaps.keySet();
    }
}

