/*
 * Decompiled with CFR 0.152.
 */
package org.ngrinder.common.util;

import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.ngrinder.common.util.Preconditions;
import org.ngrinder.common.util.PropertiesKeyMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesWrapper {
    private final Properties properties;
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertiesWrapper.class);
    private PropertiesKeyMapper propertiesKeyMapper;

    public PropertiesWrapper(Properties properties, PropertiesKeyMapper propertiesKeyMapper) {
        this.properties = properties;
        this.propertiesKeyMapper = propertiesKeyMapper;
    }

    public boolean exist(String key) {
        String value = this.properties.getProperty(key);
        if (value != null) {
            return true;
        }
        List<String> keys = this.propertiesKeyMapper.getKeys(key);
        if (keys != null && !keys.isEmpty()) {
            for (String each : keys) {
                value = this.properties.getProperty(each);
                if (value == null) continue;
                return true;
            }
        }
        return false;
    }

    public String getProperty(String key) {
        String value = this.properties.getProperty(key);
        if (StringUtils.isNotBlank((String)value)) {
            return value.trim();
        }
        List<String> keys = this.propertiesKeyMapper.getKeys(key);
        for (String each : Preconditions.checkNotNull(keys, key + " should be exists")) {
            value = this.properties.getProperty(each);
            if (!StringUtils.isNotBlank((String)value)) continue;
            return value.trim();
        }
        return this.propertiesKeyMapper.getDefaultValue(key);
    }

    public String getProperty(String key, String defaultValue) {
        try {
            String property = this.getProperty(key);
            return StringUtils.isEmpty((String)property) ? defaultValue : property;
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
    }

    public int getPropertyInt(String key, int defaultValue) {
        try {
            return this.getPropertyInt(key);
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
    }

    public boolean getPropertyBoolean(String key, boolean defaultValue) {
        try {
            return this.getPropertyBoolean(key);
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
    }

    public void addProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public int getPropertyInt(String key) {
        return NumberUtils.toInt((String)this.getProperty(key));
    }

    public long getPropertyLong(String key) {
        return NumberUtils.toLong((String)this.getProperty(key));
    }

    public boolean getPropertyBoolean(String key) {
        return BooleanUtils.toBoolean((String)this.getProperty(key));
    }
}

