/*
 * Decompiled with CFR 0.152.
 */
package org.ngrinder.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sun.jmx.mbeanserver.Util;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.SortedSet;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Transient;
import net.grinder.common.GrinderProperties;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.SortNatural;
import org.hibernate.annotations.Type;
import org.ngrinder.common.util.AccessUtils;
import org.ngrinder.common.util.DateUtils;
import org.ngrinder.model.BaseModel;
import org.ngrinder.model.Cloneable;
import org.ngrinder.model.RampUp;
import org.ngrinder.model.Status;
import org.ngrinder.model.Tag;
import org.ngrinder.model.User;

@Entity
@Table(name="PERF_TEST")
public class PerfTest
extends BaseModel<PerfTest> {
    private static final int MARGIN_FOR_ABBREVIATION = 8;
    private static final int MAX_LONG_STRING_SIZE = 2048;
    private static final long serialVersionUID = 1369809450686098944L;
    private static final int MAX_STRING_SIZE = 2048;
    private static final String DEFAULT_SCM = "svn";
    @Cloneable
    @Column(name="name")
    private String testName;
    @Cloneable
    @Column(name="tag_string")
    private String tagString;
    @Cloneable
    @Column(length=2048)
    private String description;
    @Enumerated(value=EnumType.STRING)
    @Column(name="status")
    private Status status;
    @Cloneable
    @Column(name="ignore_sample_count")
    private Integer ignoreSampleCount;
    @Column(name="scheduled_time")
    @Index(name="scheduled_time_index")
    private Date scheduledTime;
    @Column(name="start_time")
    private Date startTime;
    @Column(name="finish_time")
    private Date finishTime;
    @Cloneable
    @Column(name="target_hosts", length=65535)
    private String targetHosts;
    @Cloneable
    @Column(name="send_mail", columnDefinition="char(1)")
    @Type(type="true_false")
    private Boolean sendMail;
    @Cloneable
    @Column(name="use_rampup", columnDefinition="char(1)")
    @Type(type="true_false")
    private Boolean useRampUp;
    @Cloneable
    @Column(name="ramp_up_type")
    @Enumerated(value=EnumType.STRING)
    private RampUp rampUpType;
    @Cloneable
    @Column(name="threshold")
    private String threshold;
    @Cloneable
    @Column(name="scm")
    private String scm;
    @Cloneable
    @Column(name="script_name")
    private String scriptName;
    @Cloneable
    @Column(name="duration")
    private Long duration;
    @Cloneable
    @Column(name="run_count")
    private Integer runCount;
    @Cloneable
    @Column(name="agent_count")
    private Integer agentCount;
    @Cloneable
    @Column(name="vuser_per_agent")
    private Integer vuserPerAgent;
    @Cloneable
    @Column(name="processes")
    private Integer processes;
    @Cloneable
    @Column(name="ramp_up_init_count")
    private Integer rampUpInitCount;
    @Cloneable
    @Column(name="ramp_up_init_sleep_time")
    private Integer rampUpInitSleepTime;
    @Cloneable
    @Column(name="ramp_up_step")
    private Integer rampUpStep;
    @Cloneable
    @Column(name="ramp_up_increment_interval")
    private Integer rampUpIncrementInterval;
    @Cloneable
    @Column(name="threads")
    private Integer threads;
    @Column(name="tests")
    private Long tests;
    @Column(name="errors")
    private Long errors;
    @Column(name="mean_test_time")
    private Double meanTestTime;
    @Column(name="test_time_standard_deviation")
    private Double testTimeStandardDeviation;
    @Column(name="tps")
    private Double tps;
    @Column(name="peak_tps")
    private Double peakTps;
    @JsonIgnore
    @Column(name="port")
    private Integer port;
    @Column(name="test_error_cause")
    @Enumerated(value=EnumType.STRING)
    private Status testErrorCause;
    @JsonIgnore
    @Column(name="distribution_path")
    private String distributionPath;
    @Column(name="progress_message", length=2048)
    private String progressMessage;
    @Column(name="last_progress_message", length=2048)
    private String lastProgressMessage;
    @Column(name="test_comment", length=2048)
    private String testComment;
    @Column(name="script_revision")
    private String scriptRevision;
    @Column(name="stop_request")
    @Type(type="true_false")
    private Boolean stopRequest;
    @Cloneable
    @Column(name="region")
    private String region;
    @Column(name="safe_distribution", columnDefinition="char(1)")
    @Cloneable
    @Type(type="true_false")
    private Boolean safeDistribution;
    @Column(name="ignore_too_many_error", columnDefinition="char(1)")
    @Cloneable
    @Type(type="true_false")
    private Boolean ignoreTooManyError;
    @JsonIgnore
    @Transient
    private GrinderProperties grinderProperties;
    @JsonIgnore
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinTable(name="PERF_TEST_TAG", joinColumns={@JoinColumn(name="perf_test_id")}, inverseJoinColumns={@JoinColumn(name="tag_id")})
    @SortNatural
    private SortedSet<Tag> tags;
    @Cloneable
    @Column(name="sampling_interval")
    private Integer samplingInterval;
    @Cloneable
    @Column(name="param")
    private String param;

    public PerfTest() {
    }

    public PerfTest(User createdUser) {
        this.setCreatedUser(createdUser);
        this.setLastModifiedUser(createdUser);
    }

    @PrePersist
    @PreUpdate
    public void init() {
        this.status = AccessUtils.getSafe(this.status, Status.SAVED);
        this.agentCount = AccessUtils.getSafe(this.agentCount);
        this.port = AccessUtils.getSafe(this.port);
        this.processes = AccessUtils.getSafe(this.processes, 1);
        this.threads = AccessUtils.getSafe(this.threads, 1);
        this.scriptName = AccessUtils.getSafe(this.scriptName, "");
        this.testName = AccessUtils.getSafe(this.testName, "");
        this.progressMessage = AccessUtils.getSafe(this.progressMessage, "");
        this.lastProgressMessage = AccessUtils.getSafe(this.lastProgressMessage, "");
        this.testComment = AccessUtils.getSafe(this.testComment, "");
        this.threshold = AccessUtils.getSafe(this.threshold, "D");
        if (this.isThresholdRunCount().booleanValue()) {
            this.setIgnoreSampleCount(0);
        } else {
            this.ignoreSampleCount = AccessUtils.getSafe(this.ignoreSampleCount);
        }
        this.runCount = AccessUtils.getSafe(this.runCount);
        this.stopRequest = AccessUtils.getSafe(this.stopRequest, false);
        this.duration = AccessUtils.getSafe(this.duration, 60000L);
        this.samplingInterval = AccessUtils.getSafe(this.samplingInterval, 2);
        this.scriptRevision = AccessUtils.getSafe(this.scriptRevision, "-1");
        this.param = AccessUtils.getSafe(this.param, "");
        this.scm = AccessUtils.getSafe(this.scm, DEFAULT_SCM);
        this.region = AccessUtils.getSafe(this.region, "NONE");
        this.targetHosts = AccessUtils.getSafe(this.targetHosts, "");
        this.description = AccessUtils.getSafe(this.description, "");
        this.tagString = AccessUtils.getSafe(this.tagString, "");
        this.vuserPerAgent = AccessUtils.getSafe(this.vuserPerAgent, 1);
        this.safeDistribution = AccessUtils.getSafe(this.safeDistribution, false);
        this.ignoreTooManyError = AccessUtils.getSafe(this.ignoreTooManyError, false);
        this.useRampUp = AccessUtils.getSafe(this.useRampUp, false);
        this.rampUpInitCount = AccessUtils.getSafe(this.rampUpInitCount, 0);
        this.rampUpStep = AccessUtils.getSafe(this.rampUpStep, 1);
        this.rampUpInitSleepTime = AccessUtils.getSafe(this.rampUpInitSleepTime, 0);
        this.rampUpIncrementInterval = AccessUtils.getSafe(this.rampUpIncrementInterval, 1000);
        this.rampUpType = AccessUtils.getSafe(this.rampUpType, RampUp.PROCESS);
    }

    @JsonIgnore
    public String getTestIdentifier() {
        return "perftest_" + this.getId() + "_" + this.getLastModifiedUser().getUserId();
    }

    @JsonIgnore
    public long getTotalRunCount() {
        return (long)(this.getAgentCount() * this.getThreads() * this.getProcesses()) * (long)this.getRunCount().intValue();
    }

    public String getDescription() {
        return StringUtils.abbreviate((String)this.description, (int)2040);
    }

    @JsonIgnore
    public String getLastModifiedDateToStr() {
        return DateUtils.dateToString(this.getLastModifiedDate());
    }

    @JsonIgnore
    public List<String> getTargetHostIP() {
        String[] hostsList;
        ArrayList<String> targetIPList = new ArrayList<String>();
        for (String hosts : hostsList = StringUtils.split((String)StringUtils.trimToEmpty((String)this.targetHosts), (String)",")) {
            String[] addresses = StringUtils.split((String)hosts, (String)":");
            if (addresses.length <= 2) {
                targetIPList.add(addresses[addresses.length - 1]);
                continue;
            }
            targetIPList.add(hosts.substring(hosts.indexOf(":") + 1, hosts.length()));
        }
        return targetIPList;
    }

    @JsonIgnore
    public Boolean isThresholdDuration() {
        return "D".equals(this.getThreshold());
    }

    @JsonIgnore
    public Boolean isThresholdRunCount() {
        return "R".equals(this.getThreshold());
    }

    public boolean isStopRequest() {
        return AccessUtils.getSafe(this.stopRequest, false);
    }

    @JsonProperty(value="runtime")
    public String getRuntimeStr() {
        long ms = this.finishTime == null || this.startTime == null ? 0L : this.finishTime.getTime() - this.startTime.getTime();
        return DateUtils.ms2Time(ms);
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toStringExclude((Object)this, (String)"tags");
    }

    public void setProgressMessage(String progressMessage) {
        this.progressMessage = StringUtils.defaultIfEmpty((String)StringUtils.right((String)progressMessage, (int)2048), (String)"");
    }

    public void clearLastProgressMessage() {
        this.lastProgressMessage = "";
    }

    public void setLastProgressMessage(String lastProgressMessage) {
        if (StringUtils.isEmpty((String)lastProgressMessage)) {
            return;
        }
        if (!StringUtils.equals((String)this.lastProgressMessage, (String)lastProgressMessage) && !StringUtils.isEmpty((String)this.lastProgressMessage)) {
            this.setProgressMessage(this.getProgressMessage() + this.lastProgressMessage + "\n");
        }
        this.lastProgressMessage = lastProgressMessage;
    }

    public void setTestComment(String testComment) {
        this.testComment = StringUtils.trimToEmpty((String)StringUtils.right((String)testComment, (int)2048));
    }

    public void clearMessages() {
        this.clearLastProgressMessage();
        this.setProgressMessage("");
    }

    public Boolean getSafeDistribution() {
        return (Boolean)Util.cast(ObjectUtils.defaultIfNull((Object)this.safeDistribution, (Object)Boolean.FALSE));
    }

    public Boolean getIgnoreTooManyError() {
        return (Boolean)Util.cast(ObjectUtils.defaultIfNull((Object)this.ignoreTooManyError, (Object)Boolean.FALSE));
    }

    public boolean isGitHubScm() {
        return this.scm != null && !this.scm.equals(DEFAULT_SCM);
    }

    public void prepare(boolean isClone) {
        if (isClone) {
            this.setId(null);
            this.setTestComment("");
        }
        this.useRampUp = AccessUtils.getSafe(this.useRampUp);
        this.safeDistribution = AccessUtils.getSafe(this.safeDistribution);
        this.ignoreTooManyError = AccessUtils.getSafe(this.ignoreTooManyError);
    }

    public String getTestName() {
        return this.testName;
    }

    public String getTagString() {
        return this.tagString;
    }

    public Status getStatus() {
        return this.status;
    }

    public Integer getIgnoreSampleCount() {
        return this.ignoreSampleCount;
    }

    public Date getScheduledTime() {
        return this.scheduledTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getFinishTime() {
        return this.finishTime;
    }

    public String getTargetHosts() {
        return this.targetHosts;
    }

    public Boolean getSendMail() {
        return this.sendMail;
    }

    public Boolean getUseRampUp() {
        return this.useRampUp;
    }

    public RampUp getRampUpType() {
        return this.rampUpType;
    }

    public String getThreshold() {
        return this.threshold;
    }

    public String getScm() {
        return this.scm;
    }

    public String getScriptName() {
        return this.scriptName;
    }

    public Long getDuration() {
        return this.duration;
    }

    public Integer getRunCount() {
        return this.runCount;
    }

    public Integer getAgentCount() {
        return this.agentCount;
    }

    public Integer getVuserPerAgent() {
        return this.vuserPerAgent;
    }

    public Integer getProcesses() {
        return this.processes;
    }

    public Integer getRampUpInitCount() {
        return this.rampUpInitCount;
    }

    public Integer getRampUpInitSleepTime() {
        return this.rampUpInitSleepTime;
    }

    public Integer getRampUpStep() {
        return this.rampUpStep;
    }

    public Integer getRampUpIncrementInterval() {
        return this.rampUpIncrementInterval;
    }

    public Integer getThreads() {
        return this.threads;
    }

    public Long getTests() {
        return this.tests;
    }

    public Long getErrors() {
        return this.errors;
    }

    public Double getMeanTestTime() {
        return this.meanTestTime;
    }

    public Double getTestTimeStandardDeviation() {
        return this.testTimeStandardDeviation;
    }

    public Double getTps() {
        return this.tps;
    }

    public Double getPeakTps() {
        return this.peakTps;
    }

    public Integer getPort() {
        return this.port;
    }

    public Status getTestErrorCause() {
        return this.testErrorCause;
    }

    public String getDistributionPath() {
        return this.distributionPath;
    }

    public String getProgressMessage() {
        return this.progressMessage;
    }

    public String getLastProgressMessage() {
        return this.lastProgressMessage;
    }

    public String getTestComment() {
        return this.testComment;
    }

    public String getScriptRevision() {
        return this.scriptRevision;
    }

    public String getRegion() {
        return this.region;
    }

    public GrinderProperties getGrinderProperties() {
        return this.grinderProperties;
    }

    public SortedSet<Tag> getTags() {
        return this.tags;
    }

    public Integer getSamplingInterval() {
        return this.samplingInterval;
    }

    public String getParam() {
        return this.param;
    }

    public void setTestName(String testName) {
        this.testName = testName;
    }

    public void setTagString(String tagString) {
        this.tagString = tagString;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void setIgnoreSampleCount(Integer ignoreSampleCount) {
        this.ignoreSampleCount = ignoreSampleCount;
    }

    public void setScheduledTime(Date scheduledTime) {
        this.scheduledTime = scheduledTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public void setFinishTime(Date finishTime) {
        this.finishTime = finishTime;
    }

    public void setTargetHosts(String targetHosts) {
        this.targetHosts = targetHosts;
    }

    public void setSendMail(Boolean sendMail) {
        this.sendMail = sendMail;
    }

    public void setUseRampUp(Boolean useRampUp) {
        this.useRampUp = useRampUp;
    }

    public void setRampUpType(RampUp rampUpType) {
        this.rampUpType = rampUpType;
    }

    public void setThreshold(String threshold) {
        this.threshold = threshold;
    }

    public void setScm(String scm) {
        this.scm = scm;
    }

    public void setScriptName(String scriptName) {
        this.scriptName = scriptName;
    }

    public void setDuration(Long duration) {
        this.duration = duration;
    }

    public void setRunCount(Integer runCount) {
        this.runCount = runCount;
    }

    public void setAgentCount(Integer agentCount) {
        this.agentCount = agentCount;
    }

    public void setVuserPerAgent(Integer vuserPerAgent) {
        this.vuserPerAgent = vuserPerAgent;
    }

    public void setProcesses(Integer processes) {
        this.processes = processes;
    }

    public void setRampUpInitCount(Integer rampUpInitCount) {
        this.rampUpInitCount = rampUpInitCount;
    }

    public void setRampUpInitSleepTime(Integer rampUpInitSleepTime) {
        this.rampUpInitSleepTime = rampUpInitSleepTime;
    }

    public void setRampUpStep(Integer rampUpStep) {
        this.rampUpStep = rampUpStep;
    }

    public void setRampUpIncrementInterval(Integer rampUpIncrementInterval) {
        this.rampUpIncrementInterval = rampUpIncrementInterval;
    }

    public void setThreads(Integer threads) {
        this.threads = threads;
    }

    public void setTests(Long tests) {
        this.tests = tests;
    }

    public void setErrors(Long errors) {
        this.errors = errors;
    }

    public void setMeanTestTime(Double meanTestTime) {
        this.meanTestTime = meanTestTime;
    }

    public void setTestTimeStandardDeviation(Double testTimeStandardDeviation) {
        this.testTimeStandardDeviation = testTimeStandardDeviation;
    }

    public void setTps(Double tps) {
        this.tps = tps;
    }

    public void setPeakTps(Double peakTps) {
        this.peakTps = peakTps;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setTestErrorCause(Status testErrorCause) {
        this.testErrorCause = testErrorCause;
    }

    public void setDistributionPath(String distributionPath) {
        this.distributionPath = distributionPath;
    }

    public void setScriptRevision(String scriptRevision) {
        this.scriptRevision = scriptRevision;
    }

    public void setStopRequest(Boolean stopRequest) {
        this.stopRequest = stopRequest;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public void setSafeDistribution(Boolean safeDistribution) {
        this.safeDistribution = safeDistribution;
    }

    public void setIgnoreTooManyError(Boolean ignoreTooManyError) {
        this.ignoreTooManyError = ignoreTooManyError;
    }

    public void setGrinderProperties(GrinderProperties grinderProperties) {
        this.grinderProperties = grinderProperties;
    }

    public void setTags(SortedSet<Tag> tags) {
        this.tags = tags;
    }

    public void setSamplingInterval(Integer samplingInterval) {
        this.samplingInterval = samplingInterval;
    }

    public void setParam(String param) {
        this.param = param;
    }
}

