/*
 * Decompiled with CFR 0.152.
 */
package org.ngrinder.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Type;
import org.ngrinder.common.util.AccessUtils;
import org.ngrinder.model.BaseModel;
import org.ngrinder.model.Role;

@Entity
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
@Table(name="NUSER")
public class User
extends BaseModel<User> {
    private static final long serialVersionUID = 7398072895183814285L;
    @Column(name="user_id", unique=true, nullable=false)
    private String userId;
    @Column(name="user_name")
    private String userName;
    private String password;
    @Type(type="true_false")
    @Column(columnDefinition="char(1)")
    private Boolean enabled;
    private String email;
    @JsonDeserialize(using=RoleDeserializer.class)
    @Enumerated(value=EnumType.STRING)
    @Column(name="role_name", nullable=false)
    private Role role;
    private String description;
    private String timeZone;
    @Column(name="user_language")
    private String userLanguage;
    @Column(name="is_external", columnDefinition="char(1)")
    @Type(type="true_false")
    private Boolean external;
    @Column(name="authentication_provider_class")
    private String authProviderClass;
    @Transient
    private User follower;
    @Transient
    private String followersStr;
    @Transient
    private User ownerUser;
    @JsonSerialize(using=UserReferenceListSerializer.class)
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="SHARED_USER", joinColumns={@JoinColumn(name="owner_id")}, inverseJoinColumns={@JoinColumn(name="follow_id")})
    private List<User> followers;
    @JsonIgnore
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="SHARED_USER", joinColumns={@JoinColumn(name="follow_id")}, inverseJoinColumns={@JoinColumn(name="owner_id")})
    private List<User> owners;

    public User() {
    }

    public User(String userId, String name, String password, Role role) {
        this.userId = userId;
        this.password = password;
        this.userName = name;
        this.role = role;
    }

    @PrePersist
    @PreUpdate
    public void init() {
        this.userId = StringUtils.trim((String)this.userId);
        this.userName = StringUtils.trim((String)this.userName);
        this.email = AccessUtils.getSafe(StringUtils.trim((String)this.email), "");
        this.enabled = AccessUtils.getSafe(this.enabled, true);
        this.external = AccessUtils.getSafe(this.enabled);
        this.role = AccessUtils.getSafe(this.role, Role.USER);
    }

    public static User createNew() {
        User user = new User();
        user.init();
        return user;
    }

    public User(String userId, String name, String password, String email, Role role) {
        this.userId = userId;
        this.password = password;
        this.userName = name;
        this.email = email;
        this.role = role;
    }

    public boolean validate() {
        return this.userName != null && this.email != null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.userId == null ? 0 : this.userId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        User other = (User)obj;
        return !(this.userId == null ? other.userId != null : !this.userId.equals(other.userId));
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public void setEmail(String email) {
        this.email = email == null ? "" : email.toLowerCase();
    }

    public boolean isExternal() {
        return AccessUtils.getSafe(this.external);
    }

    @JsonIgnore
    public User getFactualUser() {
        return this.ownerUser == null ? this : this.ownerUser;
    }

    @JsonIgnore
    public User getUserBaseInfo() {
        User userInfo = new User();
        userInfo.setId(this.getId());
        userInfo.setUserId(this.getUserId());
        userInfo.setUserName(this.getUserName());
        userInfo.setEmail(this.getEmail());
        return userInfo;
    }

    @Override
    public String toString() {
        return "User[id=" + this.getId() + ",userId=" + this.getUserId() + ",userName=" + this.getUserName() + ",role=" + (Object)((Object)this.getRole()) + ",e-mail=" + this.getEmail() + "]";
    }

    public String getUserId() {
        return this.userId;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public String getEmail() {
        return this.email;
    }

    public Role getRole() {
        return this.role;
    }

    public String getDescription() {
        return this.description;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public String getUserLanguage() {
        return this.userLanguage;
    }

    public Boolean getExternal() {
        return this.external;
    }

    public String getAuthProviderClass() {
        return this.authProviderClass;
    }

    public User getFollower() {
        return this.follower;
    }

    public String getFollowersStr() {
        return this.followersStr;
    }

    public User getOwnerUser() {
        return this.ownerUser;
    }

    public List<User> getFollowers() {
        return this.followers;
    }

    public List<User> getOwners() {
        return this.owners;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public void setRole(Role role) {
        this.role = role;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public void setUserLanguage(String userLanguage) {
        this.userLanguage = userLanguage;
    }

    public void setExternal(Boolean external) {
        this.external = external;
    }

    public void setAuthProviderClass(String authProviderClass) {
        this.authProviderClass = authProviderClass;
    }

    public void setFollower(User follower) {
        this.follower = follower;
    }

    public void setFollowersStr(String followersStr) {
        this.followersStr = followersStr;
    }

    public void setOwnerUser(User ownerUser) {
        this.ownerUser = ownerUser;
    }

    public void setFollowers(List<User> followers) {
        this.followers = followers;
    }

    public void setOwners(List<User> owners) {
        this.owners = owners;
    }

    public static class RoleDeserializer
    extends StdDeserializer<Role> {
        RoleDeserializer() {
            this(null);
        }

        RoleDeserializer(Class<?> vc) {
            super(vc);
        }

        public Role deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            JsonNode node = (JsonNode)parser.getCodec().readTree(parser);
            JsonNode nameNode = node.get("name");
            if (nameNode == null) {
                return null;
            }
            String name = node.get("name").asText();
            return Arrays.stream(Role.values()).filter(role -> role.name().equals(name)).findFirst().orElse(null);
        }
    }

    public static class UserReferenceSerializer
    extends StdSerializer<User> {
        UserReferenceSerializer() {
            this(null);
        }

        UserReferenceSerializer(Class<User> t) {
            super(t);
        }

        public void serialize(User user, JsonGenerator generator, SerializerProvider provider) throws IOException {
            generator.writeObject((Object)user.getUserBaseInfo());
        }
    }

    private static class UserReferenceListSerializer
    extends StdSerializer<List<User>> {
        UserReferenceListSerializer() {
            this(null);
        }

        UserReferenceListSerializer(Class<List<User>> t) {
            super(t);
        }

        public void serialize(List<User> followers, JsonGenerator generator, SerializerProvider provider) throws IOException {
            List userBaseInfoList = followers.stream().map(User::getUserBaseInfo).collect(Collectors.toList());
            generator.writeObject(userBaseInfoList);
        }
    }
}

