/*
 * Decompiled with CFR 0.152.
 */
package org.ngrinder.monitor.collector;

import com.sun.jna.Platform;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import org.apache.commons.io.IOUtils;
import org.ngrinder.common.constants.MonitorConstants;
import org.ngrinder.common.util.SystemInfoUtils;
import org.ngrinder.monitor.collector.DataCollector;
import org.ngrinder.monitor.mxbean.SystemMonitoringData;
import org.ngrinder.monitor.share.domain.BandWidth;
import org.ngrinder.monitor.share.domain.SystemInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemDataCollector
extends DataCollector
implements MonitorConstants {
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemDataCollector.class);
    private SystemInfo prev = null;
    private File customDataFile = null;

    public void setAgentHome(File agentHomeFile) {
        if (this.customDataFile == null) {
            this.customDataFile = new File(agentHomeFile, "monitor" + File.separator + "custom.data");
        }
    }

    @Override
    public synchronized void refresh() {
        this.initializeSystemInfo();
    }

    private void initializeSystemInfo() {
        if (this.prev == null) {
            this.prev = new SystemInfo();
            this.prev.setBandWidth(SystemInfoUtils.getNetworkUsage());
        }
    }

    @Override
    public void run() {
        this.initializeSystemInfo();
        SystemMonitoringData systemMonitoringData = (SystemMonitoringData)this.getMXBean("name=System");
        systemMonitoringData.setSystemInfo(this.execute());
    }

    public synchronized SystemInfo execute() {
        SystemInfo systemInfo = new SystemInfo();
        systemInfo.setCollectTime(System.currentTimeMillis());
        try {
            BandWidth networkUsage = SystemInfoUtils.getNetworkUsage();
            BandWidth bandWidth = networkUsage.adjust(this.prev.getBandWidth());
            systemInfo.setBandWidth(bandWidth);
            systemInfo.setCpuUsedPercentage(SystemInfoUtils.getCpuUsedPercentage());
            systemInfo.setTotalMemory(SystemInfoUtils.getTotalMemory() / 1024L);
            systemInfo.setFreeMemory(SystemInfoUtils.getAvailableMemory() / 1024L);
            systemInfo.setSystem(Platform.isWindows() ? SystemInfo.System.WINDOW : SystemInfo.System.LINUX);
            systemInfo.setCustomValues(this.getCustomMonitorData());
        }
        catch (Throwable e) {
            LOGGER.error("Error while getting system perf data: {}", (Object)e.getMessage());
            LOGGER.debug("Error trace is ", e);
        }
        this.prev = systemInfo;
        return systemInfo;
    }

    private String getCustomMonitorData() {
        if (this.customDataFile != null && this.customDataFile.exists()) {
            String string;
            BufferedReader customDataFileReader = null;
            try {
                customDataFileReader = new BufferedReader(new FileReader(this.customDataFile));
                string = customDataFileReader.readLine();
            }
            catch (IOException e) {
                try {
                    LOGGER.debug("Error to read custom monitor data", (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(customDataFileReader);
                    throw throwable;
                }
                IOUtils.closeQuietly((Reader)customDataFileReader);
            }
            IOUtils.closeQuietly((Reader)customDataFileReader);
            return string;
        }
        return this.prev.getCustomValues();
    }
}

