/*
 * Decompiled with CFR 0.152.
 */
package org.ngrinder.monitor.share.domain;

import java.io.Closeable;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.io.IOUtils;
import org.ngrinder.common.exception.NGrinderRuntimeException;
import org.ngrinder.common.util.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MBeanClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(MBeanClient.class);
    private static final String JMX_URI = "/jndi/rmi://%s:%s/jmxrmi";
    private JMXServiceURL jmxUrl = null;
    private volatile boolean connected = false;
    private MBeanServerConnection mbeanServerConnection = null;
    private JMXConnector jmxConnector = null;
    private int timeout = 2000;

    public MBeanClient(String hostName, int port, int timeout) throws IOException {
        this(hostName, port);
        this.timeout = timeout;
    }

    public MBeanClient(String hostName, int port) throws IOException {
        this.jmxUrl = new JMXServiceURL("rmi", hostName, port, String.format(JMX_URI, hostName, port));
    }

    public void connect() {
        try {
            this.connectClient();
        }
        catch (Exception e) {
            LOGGER.info("Timeout while connecting to {}:{} monitor : {}", (Object)this.jmxUrl.getHost(), (Object)this.jmxUrl.getPort());
        }
    }

    public MBeanServerConnection getMBeanServerConnection() {
        return this.mbeanServerConnection;
    }

    public void disconnect() {
        this.connected = false;
        IOUtils.closeQuietly((Closeable)this.jmxConnector);
        this.mbeanServerConnection = null;
    }

    public Object getAttribute(ObjectName objName, String attrName) throws Exception {
        return this.mbeanServerConnection.getAttribute(objName, attrName);
    }

    private void connectClient() throws IOException, TimeoutException {
        if (this.jmxUrl == null || "localhost".equals(this.jmxUrl.getHost()) && this.jmxUrl.getPort() == 0) {
            this.mbeanServerConnection = ManagementFactory.getPlatformMBeanServer();
        } else {
            this.jmxConnector = this.connectWithTimeout(this.jmxUrl, this.timeout);
            this.mbeanServerConnection = this.jmxConnector.getMBeanServerConnection();
        }
        this.connected = true;
    }

    private JMXConnector connectWithTimeout(final JMXServiceURL jmxUrl, int timeout) throws NGrinderRuntimeException, TimeoutException {
        try {
            ExecutorService executor = Executors.newSingleThreadExecutor();
            Future<JMXConnector> future = executor.submit(new Callable<JMXConnector>(){

                @Override
                public JMXConnector call() throws IOException {
                    return JMXConnectorFactory.connect(jmxUrl);
                }
            });
            return future.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            throw e;
        }
        catch (Exception e) {
            throw ExceptionUtils.processException(e);
        }
    }

    public boolean isConnected() {
        return this.connected;
    }
}

