/*
 * Decompiled with CFR 0.152.
 */
package org.ngrinder.monitor.share.domain;

import java.io.Serializable;
import java.util.Date;
import javax.management.openmbean.CompositeData;
import org.apache.commons.lang.StringUtils;
import org.ngrinder.common.util.DateUtils;
import org.ngrinder.monitor.share.domain.BandWidth;
import org.ngrinder.monitor.share.domain.MonitorInfo;

public class SystemInfo
extends MonitorInfo
implements Serializable {
    private static final long serialVersionUID = -2995334644975166549L;
    public static final String HEADER = "ip,system,collectTime,freeMemory,totalMemory,cpuUsedPercentage,receivedPerSec,sentPerSec,customValues";
    private System system;
    protected BandWidth bandWidth;
    private long freeMemory;
    private long totalMemory;
    private float cpuUsedPercentage;
    private String ip;
    protected String customValues;

    public boolean isParsed() {
        return true;
    }

    @Override
    public void parse(CompositeData cd) {
        if (cd == null) {
            return;
        }
        try {
            long collectTime = SystemInfo.getLong(cd, "collectTime");
            this.setCollectTime(collectTime);
            String string = SystemInfo.getString(cd, "system");
            this.system = System.valueOf(string);
            this.freeMemory = SystemInfo.getLong(cd, "freeMemory");
            this.totalMemory = SystemInfo.getLong(cd, "totalMemory");
            this.cpuUsedPercentage = SystemInfo.getFloat(cd, "cpuUsedPercentage");
            if (SystemInfo.containsKey(cd, "bandWidth")) {
                CompositeData bandWidth = (CompositeData)SystemInfo.getObject(cd, "bandWidth");
                this.bandWidth = new BandWidth(collectTime);
                long receivedPerSec = SystemInfo.getLong(bandWidth, "receivedPerSec");
                long sentPerSec = SystemInfo.getLong(bandWidth, "sentPerSec");
                this.bandWidth.setReceivedPerSec(receivedPerSec);
                this.bandWidth.setSentPerSec(sentPerSec);
            }
            if (SystemInfo.containsKey(cd, "customValues")) {
                this.setCustomValues(SystemInfo.getString(cd, "customValues"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setSystem(String system) {
        this.system = System.valueOf(system);
    }

    public String toRecordString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.ip).append(",").append((Object)this.system).append(",");
        sb.append(DateUtils.getCollectTimeInLong(new Date(this.getCollectTime()))).append(",").append(this.freeMemory).append(",");
        sb.append(this.totalMemory).append(",").append(this.cpuUsedPercentage);
        if (this.bandWidth != null) {
            sb.append(",").append(this.bandWidth.getReceivedPerSec()).append(",").append(this.bandWidth.getSentPerSec());
        }
        if (this.customValues != null) {
            sb.append(",").append(this.customValues);
        }
        return sb.toString();
    }

    public System getSystem() {
        return this.system;
    }

    public BandWidth getBandWidth() {
        return this.bandWidth;
    }

    public long getFreeMemory() {
        return this.freeMemory;
    }

    public long getTotalMemory() {
        return this.totalMemory;
    }

    public float getCpuUsedPercentage() {
        return this.cpuUsedPercentage;
    }

    public String getIp() {
        return this.ip;
    }

    public String getCustomValues() {
        return this.customValues;
    }

    public void setSystem(System system) {
        this.system = system;
    }

    public void setBandWidth(BandWidth bandWidth) {
        this.bandWidth = bandWidth;
    }

    public void setFreeMemory(long freeMemory) {
        this.freeMemory = freeMemory;
    }

    public void setTotalMemory(long totalMemory) {
        this.totalMemory = totalMemory;
    }

    public void setCpuUsedPercentage(float cpuUsedPercentage) {
        this.cpuUsedPercentage = cpuUsedPercentage;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setCustomValues(String customValues) {
        this.customValues = customValues;
    }

    @Override
    public String toString() {
        return "SystemInfo(super=" + super.toString() + ", system=" + (Object)((Object)this.getSystem()) + ", bandWidth=" + this.getBandWidth() + ", freeMemory=" + this.getFreeMemory() + ", totalMemory=" + this.getTotalMemory() + ", cpuUsedPercentage=" + this.getCpuUsedPercentage() + ", ip=" + this.getIp() + ", customValues=" + this.getCustomValues() + ")";
    }

    public static class NullSystemInfo
    extends SystemInfo {
        private static final NullSystemInfo instance = new NullSystemInfo();

        public static SystemInfo getNullSystemInfo() {
            return instance;
        }

        @Override
        public String toRecordString() {
            StringBuilder sb = new StringBuilder();
            sb.append("null").append(",").append("null").append(",");
            sb.append("null").append(",").append("null").append(",");
            sb.append("null").append(",").append("null");
            if (this.bandWidth != null) {
                sb.append(",").append("null").append(",").append("null");
            }
            if (this.customValues != null) {
                int valueCount = StringUtils.countMatches((String)this.customValues, (String)",") + 1;
                for (int i = 0; i < valueCount; ++i) {
                    sb.append(",").append("null");
                }
            }
            return sb.toString();
        }

        @Override
        public boolean isParsed() {
            return false;
        }
    }

    public static enum System {
        LINUX,
        WINDOW;

    }
}

