/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.xd.common.type;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang.StringUtils;
import org.nhindirect.xd.common.DirectDocument2;
import org.nhindirect.xd.common.DirectDocuments;
import org.nhindirect.xd.common.type.FormatCodeEnum;
import org.nhindirect.xd.transform.util.type.MimeType;

public enum DirectDocumentType {
    CCD(FormatCodeEnum.HL7_CCD_DOCUMENT, MimeType.TEXT_XML){

        @Override
        public boolean matches(String data, String contentType, String fileName) {
            return StringUtils.contains((String)data, (String)"POCD_HD000040");
        }

        @Override
        public void parse(String data, DirectDocuments.SubmissionSet submissionSet) throws Exception {
        }

        @Override
        public void parse(String data, DirectDocument2.Metadata metadata) throws Exception {
        }
    }
    ,
    XDM(null, null){

        @Override
        public boolean matches(String data, String contentType, String fileName) {
            return StringUtils.contains((String)fileName, (String)".zip");
        }
    }
    ,
    PDF(null, MimeType.APPLICATION_PDF),
    XML(null, MimeType.TEXT_XML),
    HTML(null, MimeType.TEXT_HTML),
    TEXT(null, MimeType.TEXT_PLAIN),
    UNKNOWN(null, MimeType.TEXT_PLAIN){

        @Override
        public boolean matches(String data, String contentType, String fileName) {
            return true;
        }
    };

    private FormatCodeEnum formatCode;
    private MimeType mimeType;

    private DirectDocumentType(FormatCodeEnum formatCode, MimeType mimeType) {
        this.formatCode = formatCode;
        this.mimeType = mimeType;
    }

    public boolean matches(MimeMessage mimeMessage) throws MessagingException, IOException {
        return this.matches((String)mimeMessage.getContent(), mimeMessage.getContentType(), mimeMessage.getFileName());
    }

    public boolean matches(BodyPart bodyPart) throws MessagingException, IOException {
        String s = DirectDocumentType.read(bodyPart);
        return this.matches(s, bodyPart.getContentType(), bodyPart.getFileName());
    }

    public boolean matches(String data, String contentType, String fileName) {
        return StringUtils.containsIgnoreCase((String)contentType, (String)this.mimeType.getType());
    }

    public void parse(String data, DirectDocuments.SubmissionSet submissionSet) throws Exception {
    }

    public void parse(String data, DirectDocument2.Metadata metadata) throws Exception {
    }

    public static DirectDocumentType lookup(MimeMessage mimeMessage) throws MessagingException, IOException {
        for (DirectDocumentType d : DirectDocumentType.values()) {
            if (!d.matches(mimeMessage)) continue;
            return d;
        }
        return UNKNOWN;
    }

    public static DirectDocumentType lookup(BodyPart bodyPart) throws MessagingException, IOException {
        for (DirectDocumentType d : DirectDocumentType.values()) {
            if (!d.matches(bodyPart)) continue;
            return d;
        }
        return UNKNOWN;
    }

    public FormatCodeEnum getFormatCode() {
        return this.formatCode;
    }

    public MimeType getMimeType() {
        return this.mimeType;
    }

    private static String read(BodyPart bodyPart) throws MessagingException, IOException {
        InputStream inputStream = bodyPart.getInputStream();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        int data = 0;
        byte[] buffer = new byte[1024];
        while ((data = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, data);
        }
        inputStream.close();
        return new String(outputStream.toByteArray());
    }
}

