/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.xd.routing;

import java.util.ArrayList;
import java.util.Collection;

public abstract class RoutingResolver {
    public abstract String resolve(String var1);

    public abstract boolean isXdEndpoint(String var1);

    public abstract boolean isSmtpEndpoint(String var1);

    public Collection<String> getSmtpEndpoints(Collection<String> addresses) {
        ArrayList<String> smtpEndpoints = new ArrayList<String>();
        for (String address : addresses) {
            if (!this.isSmtpEndpoint(address)) continue;
            smtpEndpoints.add(address);
        }
        return smtpEndpoints;
    }

    public Collection<String> getXdEndpoints(Collection<String> addresses) {
        ArrayList<String> xdEndpoints = new ArrayList<String>();
        for (String address : addresses) {
            if (!this.isXdEndpoint(address)) continue;
            xdEndpoints.add(address);
        }
        return xdEndpoints;
    }

    public boolean hasSmtpEndpoints(Collection<String> addresses) {
        return !this.getSmtpEndpoints(addresses).isEmpty();
    }

    public boolean hasXdEndpoints(Collection<String> addresses) {
        return !this.getXdEndpoints(addresses).isEmpty();
    }
}

