/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.xd.soap;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SafeThreadData {
    public static final String MESSAGE = "message";
    public static final String ACTION = "action";
    public static final String REPLY = "reply";
    public static final String TO = "to";
    public static final String RELATESTO = "relatesto";
    public static final String THISHOST = "thishost";
    public static final String REMOTEHOST = "remotehost";
    public static final String PID = "pid";
    public static final String FROM = "from";
    public static final String DIRECT_TO = "directTo";
    public static final String DIRECT_FROM = "directFrom";
    public static final String DIRECT_METADATA_LEVEL = "directMetadataLevel";
    public static final String REPLY_EMAIL = "replyEmail";
    public static final String SUFFIX = "suffix";
    public static final String ENDPOINT = "endpoint";
    private Long threadId = null;
    private String messageId;
    private String action;
    private String reply;
    private String to;
    private String relatesTo;
    private String thisHost;
    private String remoteHost;
    private String pid;
    private String from;
    private String directTo;
    private String directFrom;
    private String directMetadataLevel;
    private String replyEmail;
    private String suffix;
    private String endpoint;
    private static Map<Long, Map<String, String>> threadMap = new HashMap<Long, Map<String, String>>();

    public SafeThreadData(Long id) {
        this.threadId = id;
        this.getSafeThreadData();
    }

    public static SafeThreadData GetThreadInstance(Long id) {
        SafeThreadData thread = new SafeThreadData(id);
        return thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getSafeThreadData() {
        Map<Long, Map<String, String>> map = threadMap;
        synchronized (map) {
            Map<Object, Object> map2;
            if (threadMap.containsKey(this.threadId)) {
                map2 = threadMap.get(this.threadId);
            } else {
                map2 = new HashMap();
                threadMap.put(this.threadId, map2);
            }
            this.messageId = (String)map2.get(MESSAGE);
            this.action = (String)map2.get(ACTION);
            this.reply = (String)map2.get(REPLY);
            this.to = (String)map2.get(TO);
            this.relatesTo = (String)map2.get(RELATESTO);
            this.thisHost = (String)map2.get(THISHOST);
            this.remoteHost = (String)map2.get(REMOTEHOST);
            this.pid = (String)map2.get(PID);
            this.from = (String)map2.get(FROM);
            this.directTo = (String)map2.get(DIRECT_TO);
            this.directFrom = (String)map2.get(DIRECT_FROM);
            this.directMetadataLevel = (String)map2.get(DIRECT_METADATA_LEVEL);
            this.replyEmail = (String)map2.get(REPLY_EMAIL);
            this.suffix = (String)map2.get(SUFFIX);
            this.endpoint = (String)map2.get(ENDPOINT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        HashMap<String, String> map = new HashMap<String, String>();
        Map<Long, Map<String, String>> map2 = threadMap;
        synchronized (map2) {
            map.put(MESSAGE, this.messageId);
            map.put(ACTION, this.action);
            map.put(REPLY, this.reply);
            map.put(TO, this.to);
            map.put(RELATESTO, this.relatesTo);
            map.put(THISHOST, this.thisHost);
            map.put(REMOTEHOST, this.remoteHost);
            map.put(PID, this.pid);
            map.put(FROM, this.from);
            map.put(DIRECT_TO, this.directTo);
            map.put(DIRECT_FROM, this.directFrom);
            map.put(DIRECT_METADATA_LEVEL, this.directMetadataLevel);
            map.put(REPLY_EMAIL, this.replyEmail);
            map.put(SUFFIX, this.suffix);
            map.put(ENDPOINT, this.endpoint);
            threadMap.put(this.threadId, map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clean(Long id) {
        Map<Long, Map<String, String>> map = threadMap;
        synchronized (map) {
            threadMap.remove(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Map<Long, Map<String, String>> getThreadMapView() {
        Map<Long, Map<String, String>> value;
        Map<Long, Map<String, String>> map = threadMap;
        synchronized (map) {
            value = Collections.unmodifiableMap(threadMap);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Map<Long, Map<String, String>> map = threadMap;
        synchronized (map) {
            Map<String, String> m = threadMap.get(this.threadId);
            if (m != null) {
                StringBuilder sb = new StringBuilder("ThreadData (threadId: " + this.threadId + ")" + "\n");
                for (Map.Entry<String, String> e : m.entrySet()) {
                    sb.append(" > ").append(e.getKey()).append(": ").append(e.getValue()).append("\n");
                }
                return sb.toString();
            }
        }
        return "No map found for threadId: " + this.threadId;
    }

    public Long getThreadId() {
        return this.threadId;
    }

    public void setThreadId(Long threadId) {
        this.threadId = threadId;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getReply() {
        return this.reply;
    }

    public void setReply(String reply) {
        this.reply = reply;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public String getRelatesTo() {
        return this.relatesTo;
    }

    public void setRelatesTo(String relatesTo) {
        this.relatesTo = relatesTo;
    }

    public String getThisHost() {
        return this.thisHost;
    }

    public void setThisHost(String thisHost) {
        this.thisHost = thisHost;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setRemoteHost(String remoteHost) {
        this.remoteHost = remoteHost;
    }

    public String getPid() {
        return this.pid;
    }

    public void setPid(String pid) {
        this.pid = pid;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getDirectTo() {
        return this.directTo;
    }

    public void setDirectTo(String directTo) {
        this.directTo = directTo;
    }

    public void setDirectTo(List<String> list) {
        this.directTo = "";
        for (String addr : list) {
            if (!this.directTo.isEmpty()) {
                this.directTo = this.directTo + ";";
            }
            this.directTo = this.directTo + "mailto:" + addr;
        }
    }

    public String getDirectFrom() {
        return this.directFrom;
    }

    public void setDirectFrom(String directFrom) {
        this.directFrom = directFrom;
    }

    public String getDirectMetadataLevel() {
        return this.directMetadataLevel;
    }

    public void setDirectMetadataLevel(String directMetadataLevel) {
        this.directMetadataLevel = directMetadataLevel;
    }

    public String getReplyEmail() {
        return this.replyEmail;
    }

    public void setReplyEmail(String replyEmail) {
        this.replyEmail = replyEmail;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public static Map<Long, Map<String, String>> getThreadMap() {
        return threadMap;
    }

    public static void setThreadMap(Map<Long, Map<String, String>> threadMap) {
        SafeThreadData.threadMap = threadMap;
    }
}

