/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.xd.transform.util;

import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.InputStream;
import java.sql.Timestamp;
import java.util.Hashtable;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XslConversion {
    private static Hashtable<String, Templates> conversions = new Hashtable(10);
    private static final Log LOGGER = LogFactory.getFactory().getInstance(XslConversion.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String run(String mapFile, String message) throws Exception {
        long start = System.currentTimeMillis();
        String retXml = "";
        Transformer transformer = null;
        try {
            Object temp;
            if (conversions.containsKey(mapFile)) {
                temp = conversions.get(mapFile);
                transformer = temp.newTransformer();
                LOGGER.info((Object)"From xsl cache");
            } else {
                temp = conversions;
                synchronized (temp) {
                    if (!conversions.containsKey(mapFile)) {
                        TransformerFactory tFactory = TransformerFactory.newInstance();
                        InputStream is = this.getClass().getClassLoader().getResourceAsStream(mapFile);
                        if (is == null) {
                            LOGGER.info((Object)("Mapfile did not read " + mapFile));
                        }
                        Templates temp2 = tFactory.newTemplates(new StreamSource(is));
                        transformer = temp2.newTransformer();
                        conversions.put(mapFile, temp2);
                    }
                }
            }
            CharArrayWriter to = new CharArrayWriter();
            transformer.transform(new StreamSource(new CharArrayReader(message.toCharArray())), new StreamResult(to));
            retXml = to.toString();
        }
        catch (TransformerConfigurationException e) {
            LOGGER.error((Object)"Exception occured during XSL conversion", (Throwable)e);
            throw e;
        }
        catch (TransformerException e) {
            LOGGER.error((Object)"Exception occured during XSL conversion", (Throwable)e);
            throw e;
        }
        if (LOGGER.isInfoEnabled()) {
            long elapse = System.currentTimeMillis() - start;
            LOGGER.info((Object)("Started at " + new Timestamp(start).toString()));
            LOGGER.info((Object)("Elapsed conversion time was " + elapse + "ms"));
        }
        return retXml;
    }
}

