/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.xd.transform.util.type;

import org.apache.commons.lang.StringUtils;

public enum MimeType {
    TEXT_PLAIN("text/plain", "txt"),
    TEXT_XML("text/xml", "xml"),
    TEXT_HTML("text/html", "html"),
    TEXT_CDA_XML("text/cda+xml", "xml"),
    APPLICATION_CCR("application/ccr", "xml"),
    APPLICATION_XML("application/xml", "xml"),
    APPLICATION_PDF("application/pdf", "pdf"),
    MULTIPART_MIXED("multipart/mixed", "???"),
    MULTIPART("multipart", "???"),
    UNKNOWN(null, "txt");

    private String type;
    private String suffix;

    private MimeType(String type, String suffix) {
        this.type = type;
        this.suffix = suffix;
    }

    public boolean matches(String type) {
        if (StringUtils.equalsIgnoreCase((String)type, (String)this.type)) {
            return true;
        }
        return StringUtils.startsWith((String)type, (String)this.type);
    }

    public static MimeType lookup(String type) {
        for (MimeType m : MimeType.values()) {
            if (!m.matches(type)) continue;
            return m;
        }
        return UNKNOWN;
    }

    public String getType() {
        return this.type;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String toString() {
        return this.type;
    }
}

