/*
 * Decompiled with CFR 0.152.
 */
package ninja.appengine;

import com.google.appengine.api.memcache.Expiration;
import com.google.appengine.api.memcache.MemcacheService;
import com.google.appengine.api.memcache.MemcacheServiceFactory;
import com.google.inject.Singleton;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import ninja.cache.Cache;
import org.slf4j.Logger;

@Singleton
public class AppEngineCacheImpl
implements Cache {
    private final MemcacheService memcacheService = MemcacheServiceFactory.getMemcacheService();
    private final Logger logger;

    @Inject
    public AppEngineCacheImpl(Logger logger) {
        this.logger = logger;
    }

    private void put(String key, Object value, int expiration, MemcacheService.SetPolicy policy) {
        if (expiration == Integer.MAX_VALUE) {
            this.memcacheService.put((Object)key, (Object)this.wrap(value), null, policy);
        } else {
            this.memcacheService.put((Object)key, (Object)this.wrap(value), Expiration.byDeltaSeconds((int)expiration), policy);
        }
    }

    public void add(String key, Object value, int expiration) {
        this.put(key, value, expiration, MemcacheService.SetPolicy.ADD_ONLY_IF_NOT_PRESENT);
    }

    public boolean safeAdd(String key, Object value, int expiration) {
        this.put(key, value, expiration, MemcacheService.SetPolicy.ADD_ONLY_IF_NOT_PRESENT);
        return true;
    }

    public void set(String key, Object value, int expiration) {
        this.put(key, value, expiration, MemcacheService.SetPolicy.SET_ALWAYS);
    }

    public boolean safeSet(String key, Object value, int expiration) {
        this.put(key, value, expiration, MemcacheService.SetPolicy.SET_ALWAYS);
        return true;
    }

    public void replace(String key, Object value, int expiration) {
        this.put(key, value, expiration, MemcacheService.SetPolicy.REPLACE_ONLY_IF_PRESENT);
    }

    public boolean safeReplace(String key, Object value, int expiration) {
        this.put(key, value, expiration, MemcacheService.SetPolicy.REPLACE_ONLY_IF_PRESENT);
        return true;
    }

    public Object get(String key) {
        return this.unwrap(this.memcacheService.get((Object)key));
    }

    public Map<String, Object> get(String[] keys) {
        List<String> list = Arrays.asList(keys);
        Map map = this.memcacheService.getAll(list);
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry key : map.entrySet()) {
            result.put(key.toString(), this.unwrap(map.get(key)));
        }
        return map;
    }

    public long incr(String key, int by) {
        return this.memcacheService.increment((Object)key, (long)by);
    }

    public long decr(String key, int by) {
        return this.memcacheService.increment((Object)key, (long)(-by));
    }

    public void clear() {
        this.memcacheService.clearAll();
    }

    public void delete(String key) {
        this.memcacheService.delete((Object)key);
    }

    public boolean safeDelete(String key) {
        this.memcacheService.delete((Object)key);
        return true;
    }

    public void stop() {
    }

    byte[] wrap(Object o) {
        if (o == null) {
            return null;
        }
        try {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bytes);
            oos.writeObject(o);
            return bytes.toByteArray();
        }
        catch (Exception e) {
            String ERROR_MESSAGE = "Cannot wrap a non-serializable value of type ";
            this.logger.error(ERROR_MESSAGE, (Throwable)e);
            throw new RuntimeException(ERROR_MESSAGE, e);
        }
    }

    Object unwrap(Object bytes) {
        if (bytes == null) {
            return null;
        }
        try {
            return new ObjectInputStream(new ByteArrayInputStream((byte[])bytes)){

                @Override
                protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                    return Class.forName(desc.getName(), false, Thread.currentThread().getContextClassLoader());
                }
            }.readObject();
        }
        catch (Exception e) {
            this.logger.error("Error while deserializing cached value", (Throwable)e);
            return null;
        }
    }
}

