/*
 * Decompiled with CFR 0.152.
 */
package ninja.appengine;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Properties;
import javax.mail.Session;
import ninja.postoffice.Mail;
import ninja.postoffice.Postoffice;
import ninja.postoffice.commonsmail.CommonsmailHelper;
import org.apache.commons.mail.MultiPartEmail;

@Singleton
public class AppEnginePostofficeImpl
implements Postoffice {
    private CommonsmailHelper commonsmailHelper;
    private Session session;

    @Inject
    public AppEnginePostofficeImpl(CommonsmailHelper commonsmailHelper) {
        this.commonsmailHelper = commonsmailHelper;
        Properties props = new Properties();
        this.session = Session.getDefaultInstance((Properties)props);
    }

    public void send(Mail mail) throws Exception {
        MultiPartEmail multiPartEmail = this.commonsmailHelper.createMultiPartEmailWithContent(mail);
        this.commonsmailHelper.doPopulateMultipartMailWithContent(multiPartEmail, mail);
        multiPartEmail.setMailSession(this.session);
        multiPartEmail.send();
    }
}

