/*
 * Decompiled with CFR 0.152.
 */
package ninja.appengine;

import com.google.appengine.repackaged.com.google.common.io.Files;
import com.google.appengine.tools.development.ApiProxyLocal;
import com.google.appengine.tools.development.ApiProxyLocalFactory;
import com.google.appengine.tools.development.LocalServerEnvironment;
import com.google.apphosting.api.ApiProxy;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import ninja.appengine.NinjaAppengineEnvironment;
import ninja.utils.NinjaProperties;
import org.apache.commons.lang.NotImplementedException;

@Singleton
public class NinjaAppengineEnvironmentImpl
implements NinjaAppengineEnvironment,
ApiProxy.Environment,
LocalServerEnvironment {
    private NinjaProperties ninjaProperties;
    private ApiProxyLocalFactory factory;

    @Inject
    public NinjaAppengineEnvironmentImpl(NinjaProperties ninjaProperties) {
        this.ninjaProperties = ninjaProperties;
        this.factory = new ApiProxyLocalFactory();
        if (ApiProxy.getCurrentEnvironment() == null) {
            System.out.println("No production App Engine environment found - starting local development environment");
            ApiProxyLocal proxy = this.factory.create((LocalServerEnvironment)this);
            ApiProxy.setDelegate((ApiProxy.Delegate)proxy);
            if (ninjaProperties.isTest()) {
                System.out.println("In test mode - not saving Appengine data to disk");
                proxy.setProperty("datastore.no_storage", Boolean.toString(true));
                proxy.setProperty("datastore.force_is_high_replication", Boolean.toString(true));
                proxy.setProperty("LocalSearchService.useRamDirectory", Boolean.toString(true));
            } else {
                String appengineGeneratedDir = System.getProperty("appengine.generated.dir");
                if (appengineGeneratedDir == null) {
                    appengineGeneratedDir = "target";
                }
                try {
                    Files.createParentDirs((File)new File(appengineGeneratedDir));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                System.out.println("Local datastore at: " + new File(appengineGeneratedDir + File.separator + "local_db.bin").getAbsolutePath());
                proxy.setProperty("datastore.backing_store", new File(appengineGeneratedDir + File.separator + "local_db.bin").getAbsolutePath());
            }
        }
    }

    public String getAppId() {
        return "appId";
    }

    public String getVersionId() {
        throw new NotImplementedException();
    }

    public String getEmail() {
        throw new NotImplementedException();
    }

    public boolean isLoggedIn() {
        throw new NotImplementedException();
    }

    public boolean isAdmin() {
        throw new NotImplementedException();
    }

    public String getAuthDomain() {
        throw new NotImplementedException();
    }

    public String getRequestNamespace() {
        throw new NotImplementedException();
    }

    public String getDefaultNamespace() {
        throw new NotImplementedException();
    }

    public void setDefaultNamespace(String ns) {
    }

    public Map<String, Object> getAttributes() {
        return new HashMap<String, Object>();
    }

    public void waitForServerToStart() throws InterruptedException {
    }

    public int getPort() {
        throw new NotImplementedException();
    }

    public File getAppDir() {
        return new File("/tmp/");
    }

    public String getAddress() {
        throw new NotImplementedException();
    }

    public boolean enforceApiDeadlines() {
        return false;
    }

    public boolean simulateProductionLatencies() {
        return false;
    }

    public String getHostName() {
        throw new NotImplementedException();
    }

    public long getRemainingMillis() {
        throw new NotImplementedException();
    }

    @Override
    public void initOrSkip() {
        if (ApiProxy.getCurrentEnvironment() == null) {
            ApiProxy.setEnvironmentForCurrentThread((ApiProxy.Environment)this);
        }
    }

    public String getModuleId() {
        throw new NotImplementedException();
    }
}

