/*
 * Decompiled with CFR 0.152.
 */
package ninja;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import ninja.Context;
import ninja.Cookie;
import ninja.Result;
import ninja.Route;
import ninja.i18n.Lang;
import ninja.i18n.LangImpl;
import ninja.session.FlashCookie;
import ninja.session.SessionCookie;
import ninja.utils.MockNinjaProperties;
import ninja.utils.NinjaProperties;
import ninja.utils.ResponseStreams;
import ninja.validation.Validation;
import ninja.validation.ValidationImpl;
import org.apache.commons.fileupload.FileItemIterator;

public class FakeContext
implements Context {
    private String requestContentType;
    private String requestPath;
    @Deprecated
    private String requestUri;
    private FlashCookie flashCookie;
    private SessionCookie sessionCookie;
    private List<Cookie> addedCookies = new ArrayList<Cookie>();
    private Map<String, String> cookieValues = new HashMap<String, String>();
    private Map<String, String> params = new HashMap<String, String>();
    private Map<String, String> pathParams = new HashMap<String, String>();
    private Map<String, String> headers = new HashMap<String, String>();
    private Object body;
    private Validation validation = new ValidationImpl((Lang)new LangImpl((NinjaProperties)MockNinjaProperties.create("", "")));

    public FakeContext setRequestContentType(String requestContentType) {
        this.requestContentType = requestContentType;
        return this;
    }

    public String getRequestContentType() {
        return this.requestContentType;
    }

    @Deprecated
    public FakeContext setRequestUri(String requestUri) {
        this.requestUri = requestUri;
        return this;
    }

    @Deprecated
    public String getRequestUri() {
        return this.requestUri;
    }

    public FakeContext setFlashCookie(FlashCookie flashCookie) {
        this.flashCookie = flashCookie;
        return this;
    }

    public FlashCookie getFlashCookie() {
        return this.flashCookie;
    }

    public FakeContext setSessionCookie(SessionCookie sessionCookie) {
        this.sessionCookie = sessionCookie;
        return this;
    }

    public SessionCookie getSessionCookie() {
        return this.sessionCookie;
    }

    public Context addCookie(Cookie cookie) {
        this.addedCookies.add(cookie);
        return this;
    }

    public HttpServletRequest getHttpServletRequest() {
        throw new UnsupportedOperationException("Not supported in fake context");
    }

    public HttpServletResponse getHttpServletResponse() {
        throw new UnsupportedOperationException("Not supported in fake context");
    }

    public FakeContext addParameter(String key, String value) {
        this.params.put(key, value);
        return this;
    }

    public String getParameter(String key) {
        return this.params.get(key);
    }

    public String getParameter(String key, String defaultValue) {
        String value = this.getParameter(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public Integer getParameterAsInteger(String key) {
        String value = this.getParameter(key);
        if (value == null) {
            return null;
        }
        return Integer.parseInt(value);
    }

    public Integer getParameterAsInteger(String key, Integer defaultValue) {
        String value = this.getParameter(key);
        if (value == null) {
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    public FakeContext addPathParameter(String key, String value) {
        this.pathParams.put(key, value);
        return this;
    }

    public String getPathParameter(String key) {
        return this.pathParams.get(key);
    }

    public Integer getPathParameterAsInteger(String key) {
        String value = this.getParameter(key);
        if (value == null) {
            return null;
        }
        return Integer.parseInt(value);
    }

    public Map<String, String[]> getParameters() {
        return Maps.transformValues(this.params, (Function)new Function<String, String[]>(){

            public String[] apply(@Nullable String s) {
                return new String[]{s};
            }
        });
    }

    public FakeContext addHeader(String name, String value) {
        this.headers.put(name, value);
        return this;
    }

    public String getHeader(String name) {
        return this.headers.get(name);
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public FakeContext addCookieValue(String name, String value) {
        this.cookieValues.put(name, value);
        return this;
    }

    public String getCookieValue(String name) {
        return this.cookieValues.get(name);
    }

    public FakeContext setBody(Object body) {
        this.body = body;
        return this;
    }

    public <T> T parseBody(Class<T> classOfT) {
        return classOfT.cast(this.body);
    }

    public boolean isMultipart() {
        return false;
    }

    public FileItemIterator getFileItemIterator() {
        throw new UnsupportedOperationException("Not supported in fake context");
    }

    public void handleAsync() {
        throw new UnsupportedOperationException("Not supported in fake context");
    }

    public void returnResultAsync(Result result) {
        throw new UnsupportedOperationException("Not supported in fake context");
    }

    public void asyncRequestComplete() {
        throw new UnsupportedOperationException("Not supported in fake context");
    }

    public Result controllerReturned() {
        throw new UnsupportedOperationException("Not supported in fake context");
    }

    public ResponseStreams finalizeHeaders(Result result) {
        throw new UnsupportedOperationException("Not supported in fake context");
    }

    public InputStream getInputStream() throws IOException {
        throw new UnsupportedOperationException("Not supported in fake context");
    }

    public BufferedReader getReader() throws IOException {
        throw new UnsupportedOperationException("Not supported in fake context");
    }

    public Route getRoute() {
        throw new UnsupportedOperationException("Not supported in fake context");
    }

    public FakeContext setRequestPath(String path) {
        this.requestPath = path;
        return this;
    }

    public String getRequestPath() {
        return this.requestPath;
    }

    public Validation getValidation() {
        return this.validation;
    }
}

