/*
 * Decompiled with CFR 0.152.
 */
package ninja;

import com.devbliss.doctest.DocTest;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import ninja.NinjaIntegrationTestHelper;
import org.apache.http.client.utils.URIBuilder;
import org.junit.AfterClass;
import org.junit.BeforeClass;

public abstract class NinjaApiDocTest
extends DocTest {
    private static NinjaIntegrationTestHelper ninjaIntegrationTestHelper;

    @BeforeClass
    public static void startServerInTestMode() {
        System.setProperty("ninja.mode", "test");
        ninjaIntegrationTestHelper = new NinjaIntegrationTestHelper();
    }

    @AfterClass
    public static void shutdownServer() {
        System.clearProperty("ninja.mode");
        ninjaIntegrationTestHelper.shutdown();
    }

    public URI buildUri(String relativePath, Map<String, String> parameters) throws URISyntaxException {
        return this.build(relativePath, parameters).build();
    }

    public URI buildUri(String relativePath) throws URISyntaxException {
        return this.build(relativePath, null).build();
    }

    private URIBuilder build(String relativePath, Map<String, String> parameters) {
        URIBuilder uriBuilder = new URIBuilder(ninjaIntegrationTestHelper.getServerAddressAsUri()).setPath(relativePath);
        this.addParametersToURI(parameters, uriBuilder);
        return uriBuilder;
    }

    private void addParametersToURI(Map<String, String> parameters, URIBuilder uriBuilder) {
        if (parameters != null) {
            for (Map.Entry<String, String> param : parameters.entrySet()) {
                uriBuilder.setParameter(param.getKey(), param.getValue());
            }
        }
    }
}

