/*
 * Decompiled with CFR 0.152.
 */
package ninja;

import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ParseException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.codehaus.jackson.map.ObjectMapper;

public class NinjaApiTestHelper {
    public static HttpResponse makeRequestAndGetResponse(String url, Map<String, String> headers) {
        HttpResponse response = null;
        try {
            DefaultHttpClient httpClient = new DefaultHttpClient();
            HttpGet getRequest = new HttpGet(url);
            for (Map.Entry<String, String> header : headers.entrySet()) {
                getRequest.addHeader(header.getKey(), header.getValue());
            }
            response = httpClient.execute((HttpUriRequest)getRequest);
            httpClient.getConnectionManager().shutdown();
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return response;
    }

    public static String makeRequest(String url) {
        return NinjaApiTestHelper.makeRequest(url, null);
    }

    public static String makeRequest(String url, Map<String, String> headers) {
        StringBuffer sb = new StringBuffer();
        try {
            String output;
            HttpResponse response;
            DefaultHttpClient httpClient = new DefaultHttpClient();
            HttpGet getRequest = new HttpGet(url);
            if (headers != null) {
                for (Map.Entry<String, String> header : headers.entrySet()) {
                    getRequest.addHeader(header.getKey(), header.getValue());
                }
            }
            if ((response = httpClient.execute((HttpUriRequest)getRequest)).getStatusLine().getStatusCode() != 200) {
                throw new RuntimeException("Failed : HTTP error code : " + response.getStatusLine().getStatusCode());
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            while ((output = br.readLine()) != null) {
                sb.append(output);
            }
            httpClient.getConnectionManager().shutdown();
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public static String uploadFile(String url, String paramName, File fileToUpload) {
        String response = null;
        try {
            DefaultHttpClient client = new DefaultHttpClient();
            client.getParams().setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_1);
            HttpPost post = new HttpPost(url);
            MultipartEntity entity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
            entity.addPart(paramName, (ContentBody)new FileBody(fileToUpload, "application/zip"));
            post.setEntity((HttpEntity)entity);
            response = EntityUtils.toString((HttpEntity)client.execute((HttpUriRequest)post).getEntity(), (String)"UTF-8");
            client.getConnectionManager().shutdown();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return response;
    }

    public static String makeJsonRequest(String url) {
        HashMap headers = Maps.newHashMap();
        headers.put("accept", "application/json; charset=utf-8");
        return NinjaApiTestHelper.makeRequest(url, headers);
    }

    public static String postJson(String url, Object object) {
        HashMap headers = Maps.newHashMap();
        headers.put("Content-Type", "application/json");
        DefaultHttpClient client = new DefaultHttpClient();
        try {
            client.getParams().setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_1);
            HttpPost post = new HttpPost(url);
            StringEntity entity = new StringEntity(new ObjectMapper().writeValueAsString(object));
            entity.setContentType("application/json");
            post.setEntity((HttpEntity)entity);
            String string = EntityUtils.toString((HttpEntity)client.execute((HttpUriRequest)post).getEntity(), (String)"UTF-8");
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

