/*
 * Decompiled with CFR 0.152.
 */
package ninja;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.Filter;
import ninja.NinjaServletDispatcher;
import org.apache.http.client.utils.URIBuilder;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.DefaultServlet;
import org.mortbay.jetty.servlet.FilterHolder;

public class NinjaIntegrationTestHelper {
    private final int port = NinjaIntegrationTestHelper.findAvailablePort(1000, 10000);
    private final Server server;
    private final URI serverUri = this.createServerUri();

    public NinjaIntegrationTestHelper() {
        this.server = new Server();
        try {
            SelectChannelConnector con = new SelectChannelConnector();
            con.setPort(this.port);
            this.server.addConnector((Connector)con);
            Context context = new Context((HandlerContainer)this.server, "/");
            context.addServlet(DefaultServlet.class, "/*");
            context.addFilter(new FilterHolder((Filter)new NinjaServletDispatcher(this.serverUri.toString())), "/*", 15);
            this.server.start();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public String getServerAddress() {
        return this.serverUri.toString() + "/";
    }

    public URI getServerAddressAsUri() {
        return this.serverUri;
    }

    private URI createServerUri() {
        try {
            return new URIBuilder().setScheme("http").setHost("localhost").setPort(this.port).build();
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public void shutdown() {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static int findAvailablePort(int min, int max) {
        for (int port = min; port < max; ++port) {
            try {
                new ServerSocket(port).close();
                return port;
            }
            catch (IOException iOException) {
                continue;
            }
        }
        throw new IllegalStateException("Could not find available port in range " + min + " to " + max);
    }
}

