/*
 * Decompiled with CFR 0.152.
 */
package ninja;

import com.google.common.io.ByteStreams;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import ninja.AssetsControllerHelper;
import ninja.Context;
import ninja.Renderable;
import ninja.Result;
import ninja.Results;
import ninja.utils.HttpCacheToolkit;
import ninja.utils.MimeTypes;
import ninja.utils.NinjaProperties;
import ninja.utils.ResponseStreams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AssetsController {
    private static final Logger logger = LoggerFactory.getLogger(AssetsController.class);
    public static final String ASSETS_DIR = "assets";
    public static final String FILENAME_PATH_PARAM = "fileName";
    private final MimeTypes mimeTypes;
    private final HttpCacheToolkit httpCacheToolkit;
    private final NinjaProperties ninjaProperties;
    private final AssetsControllerHelper assetsControllerHelper;

    @Inject
    public AssetsController(AssetsControllerHelper assetsControllerHelper, HttpCacheToolkit httpCacheToolkit, MimeTypes mimeTypes, NinjaProperties ninjaProperties) {
        this.assetsControllerHelper = assetsControllerHelper;
        this.httpCacheToolkit = httpCacheToolkit;
        this.mimeTypes = mimeTypes;
        this.ninjaProperties = ninjaProperties;
    }

    public Result serveStatic() {
        Renderable renderable = new Renderable(){

            @Override
            public void render(Context context, Result result) {
                String fileName = AssetsController.getFileNameFromPathOrReturnRequestPath(context);
                URL url = AssetsController.this.getStaticFileFromAssetsDir(fileName);
                AssetsController.this.streamOutUrlEntity(url, context, result);
            }
        };
        return Results.ok().render((Object)renderable);
    }

    public Result serveWebJars() {
        Renderable renderable = new Renderable(){

            @Override
            public void render(Context context, Result result) {
                String fileName = AssetsController.getFileNameFromPathOrReturnRequestPath(context);
                URL url = AssetsController.this.getStaticFileFromMetaInfResourcesDir(fileName);
                AssetsController.this.streamOutUrlEntity(url, context, result);
            }
        };
        return Results.ok().render((Object)renderable);
    }

    private void streamOutUrlEntity(URL url, Context context, Result result) {
        block30: {
            if (url == null) {
                context.finalizeHeadersWithoutFlashAndSessionCookie(Results.notFound());
            } else {
                try {
                    URLConnection urlConnection = url.openConnection();
                    Long lastModified = urlConnection.getLastModified();
                    this.httpCacheToolkit.addEtag(context, result, lastModified);
                    if (result.getStatusCode() == 304) {
                        context.finalizeHeadersWithoutFlashAndSessionCookie(result);
                        break block30;
                    }
                    result.status(200);
                    String mimeType = this.mimeTypes.getContentType(context, url.getFile());
                    if (mimeType != null && !mimeType.isEmpty()) {
                        result.contentType(mimeType);
                    }
                    ResponseStreams responseStreams = context.finalizeHeadersWithoutFlashAndSessionCookie(result);
                    try (InputStream inputStream = urlConnection.getInputStream();
                         OutputStream outputStream = responseStreams.getOutputStream();){
                        ByteStreams.copy((InputStream)inputStream, (OutputStream)outputStream);
                    }
                }
                catch (IOException e) {
                    logger.error("error streaming file", (Throwable)e);
                }
            }
        }
    }

    private URL getStaticFileFromAssetsDir(String fileName) {
        URL url = null;
        if (this.ninjaProperties.isDev() && new File(this.assetsDirInDevModeWithoutTrailingSlash()).exists()) {
            String finalNameWithoutLeadingSlash = this.assetsControllerHelper.normalizePathWithoutLeadingSlash(fileName, false);
            File possibleFile = new File(this.assetsDirInDevModeWithoutTrailingSlash() + File.separator + finalNameWithoutLeadingSlash);
            url = this.getUrlForFile(possibleFile);
        } else {
            String finalNameWithoutLeadingSlash = this.assetsControllerHelper.normalizePathWithoutLeadingSlash(fileName, true);
            url = this.getClass().getClassLoader().getResource("assets/" + finalNameWithoutLeadingSlash);
        }
        return url;
    }

    private URL getUrlForFile(File possibleFileInSrc) {
        if (possibleFileInSrc.exists() && !possibleFileInSrc.isDirectory()) {
            try {
                return possibleFileInSrc.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                logger.error("Error in dev mode while streaming files from src dir. ", (Throwable)malformedURLException);
            }
        }
        return null;
    }

    private URL getStaticFileFromMetaInfResourcesDir(String fileName) {
        String finalNameWithoutLeadingSlash = this.assetsControllerHelper.normalizePathWithoutLeadingSlash(fileName, true);
        URL url = null;
        url = this.getClass().getClassLoader().getResource("META-INF/resources/webjars/" + finalNameWithoutLeadingSlash);
        return url;
    }

    private static String getFileNameFromPathOrReturnRequestPath(Context context) {
        String fileName = context.getPathParameter(FILENAME_PATH_PARAM);
        if (fileName == null) {
            fileName = context.getRequestPath();
        }
        return fileName;
    }

    private String assetsDirInDevModeWithoutTrailingSlash() {
        String srcDir = System.getProperty("user.dir") + File.separator + "src" + File.separator + "main" + File.separator + "java";
        return srcDir + File.separator + ASSETS_DIR;
    }
}

