/*
 * Decompiled with CFR 0.152.
 */
package ninja;

import com.google.inject.Inject;
import ninja.Context;
import ninja.Filter;
import ninja.FilterChain;
import ninja.Ninja;
import ninja.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticityFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(AuthenticityFilter.class);
    private final Ninja ninja;

    @Inject
    public AuthenticityFilter(Ninja ninja) {
        this.ninja = ninja;
    }

    @Override
    public Result filter(FilterChain filterChain, Context context) {
        String authenticityToken = context.getParameter("authenticityToken");
        if (!context.getSession().getAuthenticityToken().equals(authenticityToken)) {
            logger.warn("Authenticity token mismatch. Request from {} is forbidden!", (Object)context.getRemoteAddr());
            return this.ninja.getForbiddenResult(context);
        }
        return filterChain.next(context);
    }
}

